//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common;

using SpaceBuilder.Utils;
using SpaceBuilder.Web;
using SpaceBuilder.Common.Mail;

namespace SpaceBuilder.File.Modules
{
    /// <summary>
    /// ļص֪ͨ
    /// </summary>
    public class DisposeNoticeForFile : IFileModule
    {
        #region IFileModule Ա

        /// <summary>
        /// ע¼
        /// </summary>
        public void Init(FileEventManager fem, System.Xml.Linq.XElement node)
        {
            fem.AfterFileCommentChange += new FilePostEventHandler(fem_AfterFileCommentChange);
        }

        void fem_AfterFileCommentChange(FileComment fileComment, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                FileThread fileThread = FileThreads.GetThread(fileComment.ThreadID, false);

                if (fileComment.UserID != fileThread.OwnerUserID)
                    return;

                string itemKey = NoticeItemKeys.Instance().NewFileComment();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                User toUser = null;
                if (fileComment.ParentID > 0)
                {
                    FileComment parentComment = FileComments.GetComment(fileComment.ParentID, null, false);
                    if (parentComment != null)
                        toUser = Users.GetUser(parentComment.UserID, false);
                }
                else
                    toUser = Users.GetUser(fileThread.OwnerUserID, false);
                NoticeRecord record = new NoticeRecord();
                record.UserID = toUser.UserID;
                record.Receiver = toUser.DisplayName;
                record.ApplicationID = ApplicationIDs.Instance().File();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = fileComment.UserID;
                record.LeadingActor = fileComment.Author;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().File());
                record.RelativeItemID = fileThread.ThreadID;
                record.RelativeItemName = fileThread.Subject;
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewFileComment", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(fileComment.UserID, fileComment.Author, true), GetFileSubjectWithHyperlink(fileThread, fileComment));
                record.RelativeItemUrl = SiteUrls.Instance().ShowFile(fileThread.ThreadID);
                record.Body = fileComment.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        /// <summary>
        /// ȡӵĲ»۵html
        /// </summary>
        private static string GetFileSubjectWithHyperlink(FileThread fileThread, FileComment fileComment)
        {
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserStory, SiteUrls.Instance().ShowFile(fileThread.ThreadID, fileComment.PostID), fileThread.Subject);
        }

        private static readonly string HyperlinkTargetOfUserStory = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
        #endregion
    }
}
