//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.File.Modules
{
    /// <summary>
    /// ļصĻ
    /// </summary>
    public class DisposePointForFile : IFileModule
    {
        #region IPostModule Ա

        public void Init(FileEventManager fem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                //fem.AfterFileCommentChange += new FilePostEventHandler(fem_AfterFileCommentChange);
                //fem.AfterFileThreadChange += new FileThreadEventHandler(fem_AfterFileThreadChange);
                fem.AfterFileThreadSetEssential += new FileThreadEventHandler(fem_AfterFileThreadSetEssential);
                fem.AfterFileThreadSetSticky += new FileThreadEventHandler(fem_AfterFileThreadSetSticky);
                fem.AfterFileDownLoadRecordChange += new DownloadRecordEventHandler(fem_AfterFileDownLoadRecordChange);
                fem.AfterPointChangeOfFileThread += new PointChangeOfFileThreadHandler(fem_AfterPointChangeOfFileThread);
                fem.AfterPointChangeOfFileComment += new PointChangeOfFileCommentHandler(fem_AfterPointChangeOfFileComment);
            }
        }

        void fem_AfterPointChangeOfFileComment(FileComment comment, GlobalEventArgs e, UserPointDirection userPointDirection)
        {

            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            FileThread fileThread = FileThreads.GetThread(comment.ThreadID, false);

            if (userPointDirection == UserPointDirection.Input)
            {

                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateFileGalleryCommet());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateFileGalleryCommet", fileThread.OwnerUser.Language, e.ApplicationID), fileThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_FileCommentAuditingSuccess", fileThread.OwnerUser.Language, e.ApplicationID), fileThread.Subject);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteFileGalleryComment());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteFileGalleryComment", fileThread.OwnerUser.Language, e.ApplicationID), HtmlUtils.TrimHtml(comment.Body, 128));
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_FileCommentAuditingFail", fileThread.OwnerUser.Language, e.ApplicationID), HtmlUtils.TrimHtml(comment.Body, 128));
            }

            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, comment.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
            Points.CreateUserPointRecords(records);
        }

        void fem_AfterPointChangeOfFileThread(FileThread fileThread, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;


            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateFileGalleryThread());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateFileGalleryThread", fileThread.OwnerUser.Language, e.ApplicationID), fileThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_FileThreadAuditingSuccess", fileThread.OwnerUser.Language, e.ApplicationID), fileThread.Subject);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteFileGalleryThread());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteFileGalleryThread", fileThread.OwnerUser.Language, e.ApplicationID), fileThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_FileThreadAuditingFail", fileThread.OwnerUser.Language, e.ApplicationID), fileThread.Subject);
            }
            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, fileThread.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            Points.CreateUserPointRecords(records);
        }

        void fem_AfterFileDownLoadRecordChange(FileDownLoadRecord record)
        {
            if (record == null)
                return;
            FileThread fileThread = FileThreads.GetThread(record.ThreadID, false);
            if (fileThread == null)
                return;

            if (fileThread.Price <= 0)
                return;

            //ϴԼļʱ
            if (fileThread.OwnerUserID == record.UserID)
                return;

            //۳
            UserPointRecord userPointRecord = new UserPointRecord();
            userPointRecord.UserID = record.UserID;
            userPointRecord.PointCategory = UserPointCategory.Trade;
            userPointRecord.PointItemName = "ļ";
            userPointRecord.Points = 0 - record.Price;
            userPointRecord.Description = string.Format("ļ{0}Ļ{1}", fileThread.Subject, fileThread.Price);

            Points.CreateUserPointRecord(userPointRecord);

            //ϵͳ۳˰
            //˰
            int tax = SiteSettingsManager.GetSiteSettings().TransactionTax;
            //˰
            int taxPoints = fileThread.Price - fileThread.Price * (100 - tax) / 100;
            Points.ChanageSystemTradePoints(taxPoints, "ļ˰", string.Format("{0}{1}ļ", SPBHtmlHelper.Instance().UserDisplayNameLink(record.UserID, record.UserDisplayName, true), SPBHtmlHelper.Instance().UserDisplayNameLink(fileThread.OwnerUser)));

            //ϴ߻
            UserPointRecord ownerPointRecord = new UserPointRecord();
            ownerPointRecord.UserID = fileThread.OwnerUserID;
            ownerPointRecord.PointCategory = UserPointCategory.Trade;
            ownerPointRecord.PointItemName = "ļ";
            ownerPointRecord.Points = fileThread.Price - taxPoints;
            ownerPointRecord.Description = string.Format("{0}ļ:{1}û{2}", record.UserDisplayName, fileThread.Subject, fileThread.Price - taxPoints);
            Points.CreateUserPointRecord(ownerPointRecord);

        }

        void fem_AfterFileThreadSetSticky(FileThread fileThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Update && fileThread.SpecialOrder > 0)
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;

                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().SetStickyFileGalleryThread());

                if (role == null)
                    return;

                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_SetStickyFileGalleryThread", fileThread.OwnerUser.Language, e.ApplicationID), fileThread.Subject);

                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, fileThread.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                SpaceBuilder.Common.Points.CreateUserPointRecords(records);
            }
        }

        void fem_AfterFileThreadSetEssential(FileThread fileThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Update && fileThread.IsEssential)
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;

                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().SetEssentialFileGalleryThread());
                if (role == null)
                    return;
                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_SetEssentialFileGalleryThread", fileThread.OwnerUser.Language, e.ApplicationID), fileThread.Subject);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, fileThread.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                SpaceBuilder.Common.Points.CreateUserPointRecords(records);
            }
        }

        #endregion
    }
}
