﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Common;


namespace SpaceBuilder.File.Modules
{
    public class DisposePointForRate : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.Rate += new RateEventHandler(em_Rate);
        }

        void em_Rate(Rating rating, GlobalEventArgs e)
        {
            if (e.ApplicationID == ApplicationIDs.Instance().File())
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;
                User user = Users.GetUser(rating.UserID, false);
                if (user == null )
                    return;
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().RateFileGalleryThread());
                if (role == null)
                    return;
                userPointRecordDescription = ResourceManager.GetString("Title_Pattern_Point_SetEssentialFileGalleryThread", user.Language, e.ApplicationID);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, rating.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);
            }
        }

        #endregion
    }
}
