//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;

namespace SpaceBuilder.File.Modules
{
    /// <summary>
    /// ƼϢصĻ
    /// </summary>
    public class DisposePointForReCommendedFile : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager gem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                gem.RecommendedItemChange += new RecommendedItemEventHandler(gem_RecommendedItemChange);
            }
        }
        #endregion


        void gem_RecommendedItemChange(RecommendedItem commendedItem, GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().File()) && (e.State == ObjectState.Create))
            {
                string itemKey = string.Empty;
                UserPointItemRole role = null;
                User user = Users.GetUser(commendedItem.AuthorUserID, false);
                if (user == null)
                    return;

                itemKey = UserPointItemKeys.Instance().RecommendedFileGalleryThread();
                role = Points.GetUserPointItemRole(itemKey);
                if (role == null)
                    return;
                string userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_RecommendedFileGalleryThread", user.Language, e.ApplicationID), commendedItem.ItemName);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, commendedItem.AuthorUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);
            }
        }
    }
}