﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.File.Modules
{
    /// <summary>
    /// 文件评论文本处理
    /// </summary>
    public class FileCommentFormatting: IFileModule
    {
        #region IFileModule 成员

        public void Init(FileEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeFileCommentChange += new FilePostEventHandler(em_BeforeFileCommentChange);
        }

        void em_BeforeFileCommentChange(FileComment filePost, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {

                if (e.State == ObjectState.Create && SiteSettingsManager.GetSiteSettings().EnableTrackPostsByIP)
                    filePost.UserHostAddress = WebUtils.IPAddress;

                //标签 脚本处理
                filePost.Body = WebUtils.HtmlEncode(filePost.Body);
                filePost.Author = WebUtils.HtmlEncode(filePost.Author);
                filePost.TitleUrl = WebUtils.HtmlEncode(filePost.TitleUrl);

                //敏感词过滤
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    filePost.Author = Censors.CensorPost(filePost.Author);
                    filePost.Body = Censors.CensorPost(filePost.Body);
                    filePost.TitleUrl = Censors.CensorPost(filePost.TitleUrl);
                }

                //表情图片处理
                if (SPBConfig.Instance().EnableEmoticon)
                {
                    filePost.Body = EmotionManager.Instance().EmoticonTransforms(filePost.Body);
                }
            }
        }

        #endregion
    }
}
