﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;


namespace SpaceBuilder.File.Modules
{
    public class FileSectionFormatting : IFileModule
    {
        #region IFileModule 成员

        public void Init(FileEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeFileSectionChange += new FileSectionEventHandler(em_BeforeFileSectionChange);
        }

        void em_BeforeFileSectionChange(FileSection fileSection, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                //标签 脚本处理
                fileSection.SectionName = WebUtils.HtmlEncode(fileSection.SectionName);
                fileSection.Description = WebUtils.HtmlEncode(fileSection.Description);

                //敏感词过滤
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    fileSection.Description = Censors.CensorPost(fileSection.Description);
                    fileSection.SectionName = Censors.CensorPost(fileSection.SectionName);
                }
            }
        }

        #endregion
    }
}
