﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.File.Modules
{
    /// <summary>
    /// 文件主题和描述文本处理
    /// </summary>
    class FileThreadFormatting : IFileModule
    {
        #region IFileModule 成员

        public void Init(FileEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeFileThreadChange += new FileThreadEventHandler(em_BeforeFileThreadChange);
        }

        void em_BeforeFileThreadChange(FileThread fileThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                #region 检查发帖时间间隔,防灌水
                if (e.State == ObjectState.Create)
                    Globals.CheckPostDate();
                #endregion

                if (e.State == ObjectState.Create && SiteSettingsManager.GetSiteSettings().EnableTrackPostsByIP)
                    fileThread.UserHostAddress = WebUtils.IPAddress;
                //标签 脚本处理
                fileThread.Subject = Formatter.FormatSingleLinePlainTextForStorage(fileThread.Subject);
                fileThread.BodyForDataTransmission = HtmlScrubber.Clean(fileThread.BodyForDataTransmission, false, true);
                //敏感词处理
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    fileThread.BodyForDataTransmission = Censors.CensorPost(fileThread.BodyForDataTransmission);
                }
            }
        }

        #endregion
    }
}
