﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.File.Modules
{
    public class UpdateFileSiteCategoryForMerge : IServiceModule
    {
        #region IServiceModule 成员

        public void Init(ServiceEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeSiteCategoryMerge += new SiteCategoryMoveOrMergeEventHandler(em_BeforeSiteCategoryMerge);
        }

        void em_BeforeSiteCategoryMerge(SiteCategory fromSiteCategory, SiteCategory toSiteCategory)
        {
            if (fromSiteCategory.ApplicationID == ApplicationIDs.Instance().File() && toSiteCategory.ApplicationID == fromSiteCategory.ApplicationID)
                FileThreads.UpdateFileSiteCategories(fromSiteCategory.CategoryID, toSiteCategory.CategoryID);
        }

        #endregion
    }
}
