﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Web;
using SpaceBuilder.Common;

using System.Web.Mvc;


namespace SpaceBuilder.File
{
    public static class SPBHtmlHelperExtensions
    {

        /// <summary>
        /// 获取文件的缩略图
        /// </summary>
        public static string ShowFileAttachmentThumbnail(this SPBHtmlHelper spbHtmlHelper, Attachment attachment, ContentTypeThumbnailSize thumbnailSize)
        {
            return spbHtmlHelper.ShowAttachmentThumbnail(attachment, thumbnailSize, null);
        }

        /// <summary>
        /// 获取文件的缩略图
        /// </summary>
        public static string ShowFileFeaturedImageThumbnail(this SPBHtmlHelper spbHtmlHelper, Attachment attachment, ContentTypeThumbnailSize thumbnailSize)
        {
            return spbHtmlHelper.ShowAttachmentThumbnail(attachment, thumbnailSize, SiteUrls.Instance().FileFeaturedImageUrl);
        }
    }
}
