﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Tasks;
using System.Xml;
using SpaceBuilder.Common;

using SpaceBuilder.File;
using SpaceBuilder.Utils;
using System.Xml.Linq;

namespace SpaceBuilder.LuceneSearch
{

    /// <summary>
    /// 定期把FileThread的变更情况更新到Lucene索引文件
    /// </summary>
    public class FileThreadIndexTask : TaskBase
    {
        /// <summary>
        /// 每次更新索引的最大数目
        /// </summary>
        private int count = 1000;

        #region ITask Members

        public override void ExecuteTask(XElement xElement)
        {
            XAttribute countNode = xElement.Attribute("count");
            if (countNode != null)
            {
                int.TryParse(countNode.Value, out count);
            }
            IndexPosts(count);
        }

        #endregion

        private void IndexPosts(int count)
        {
            SearchDataProvider dp = SearchDataProvider.Instance();
            IList<ItemForIndex> itemsForIndex = dp.GetItemsForIndex(FileSearchTypeSettings.CODE, count);

            List<ItemForIndex> createItems = new List<ItemForIndex>();
            List<ItemForIndex> updateItems = new List<ItemForIndex>();
            List<ItemForIndex> deleteItems = new List<ItemForIndex>();

            foreach (ItemForIndex item in itemsForIndex)
            {
                if (item.DataAction == ObjectState.Create)
                    createItems.Add(item);
                else if (item.DataAction == ObjectState.Update)
                    updateItems.Add(item);
                else if (item.DataAction == ObjectState.Delete)
                    deleteItems.Add(item);
            }

            #region Insert

            FileSearchManager fileSearchManager = FileSearchManager.Instance();

            IList<FileThread> createPosts = new List<FileThread>();
            foreach (ItemForIndex item in createItems)
            {
                FileThread thread = FileThreads.GetThread(item.ItemID, PrivacyStatuses.Public, true);
                if (thread != null)
                    createPosts.Add(thread);
            }

            if (fileSearchManager.Insert(createPosts))
            {
                dp.DeleteItemsForIndex(createItems);
            }
            else
            {
                foreach (ItemForIndex item in createItems)
                {
                    item.DataAction = ObjectState.Update;
                }
                dp.UpdateItemsForIndex(createItems);
            }

            #endregion

            #region Update

            IList<FileThread> updatePosts = new List<FileThread>();
            foreach (ItemForIndex item in updateItems)
            {
                FileThread thread = FileThreads.GetThread(item.ItemID, PrivacyStatuses.Public, true);
                if (thread != null)
                    updatePosts.Add(thread);
            }

            if (fileSearchManager.Update(updatePosts, m => m.Select(n => n.ThreadID).ToList(), FileIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(updateItems);
            }

            #endregion

            #region Delete
            if (deleteItems.Count > 0 && fileSearchManager.Delete(deleteItems.Select(n => n.ItemID).ToList(), FileIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(deleteItems);
            }
            #endregion
        }

    }
}