﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.File;
using SpaceBuilder.Common;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 处理文件的变更，把变更情况记录到数据库，并在<see cref="SpaceBuilder.LuceneSearch.FileThreadIndexTask"/>批量更新到Lucene索引文件中
    /// </summary>
    public class PrepareForFileThreadIndexModule : IFileModule
    {
        #region IFileModule 成员

        public void Init(FileEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterFileThreadChange += new FileThreadEventHandler(em_AfterFileThreadChange);
        }

        void em_AfterFileThreadChange(FileThread fileThread, GlobalEventArgs e)
        {
            if ((fileThread != null) && (e.State == ObjectState.Create || e.State == ObjectState.Update || e.State == ObjectState.Delete))
            {
                if (fileThread.PrivacyStatus == PrivacyStatuses.Public)
                {
                    ItemForIndex item = new ItemForIndex();
                    item.ItemID = fileThread.ThreadID;
                    item.SearchTypeCode = FileSearchTypeSettings.CODE;
                    item.DataAction = e.State;

                    SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
                }
            }
        }

        #endregion
    }
    
}
