﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.File
{
    /// <summary>
    /// 文件相关Urls
    /// </summary>
    public static class SiteUrlsExtensions
    {
        #region File

        /// <summary>
        /// 下载文件附件
        /// </summary>
        /// <param name="postID">文件PostID</param>
        public static string DownloadFileAttachment(this SiteUrls siteUrls, int threadID)
        {
            return WebUtils.ResolveUrl(string.Format("~/Services/FileAttachment.ashx?AttachmentID={0}", threadID));
        }

        /// <summary>
        /// 删除文件附件Url
        /// </summary>
        public static string DeleteFileAttachmentUrl(this SiteUrls siteUrls, int attachmentID, bool? isImage)
        {
            User currentUser = Globals.GetCurrentUser();
            if (currentUser == null)
                return string.Empty;

            return SPBUrlHelper.RouteUrl("Common", new RouteValueDictionary { { "controller", "ChannelFile" }, { "action", "DeleteFileAttachment" }, { "userDomainName", currentUser.UserName }, { "attachmentID", attachmentID }, { "isImage", isImage } });
        }

        #endregion

        #region 重复配置的URL


        /// <summary>
        /// 显示文件
        /// </summary>
        /// <param name="userDomainName">用户空间DomainName</param>
        /// <param name="threadID">文件的threadID</param>
        public static string ShowFile(this SiteUrls siteUrls, int threadID)
        {
            return SPBUrlHelper.RouteUrl("Channel_File_ShowFile", new RouteValueDictionary { { "threadID", threadID } });
        }
        /// <summary>
        /// 显示文件
        /// </summary>
        /// <param name="userDomainName">用户空间DomainName</param>
        /// <param name="threadID">文件的threadID</param>
        public static string ShowFile(this SiteUrls siteUrls, int threadID, int postID)
        {
            return ShowFile(siteUrls, threadID) + "#" + postID;
        }

        #endregion


        /// <summary>
        /// 文件频道首页
        /// </summary>
        public static string ChannelFileHome(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_File_Home");
        }


        /// <summary>
        /// 上传文件
        /// </summary>
        public static string FileUpload(this SiteUrls siteUrls)
        {
            return Globals.GetFullUrlInFileHandlerSite(FileAttachmentManager.Instance().StorageProviderName, WebUtils.ResolveUrl("~/Services/File/UploadFileAttachments.ashx"));
        }
        /// <summary>
        /// 根据用户标签列表显示文件
        /// </summary>
        public static string ListFilesByUserTag(this SiteUrls siteUrls, string userDomainName, string tagName)
        {
            return SPBUrlHelper.RouteUrl("UserDomain_File_Common", new RouteValueDictionary { { "UserDomainName", userDomainName }, { "action", "ListFilesByUserTag" }, { "tagName", WebUtils.UrlEncode(tagName) } });
        }
        /// <summary>
        /// 根据站点标签列表显示文件
        /// </summary>
        public static string ListFilesBySiteTag(this SiteUrls siteUrls, string tagName)
        {
            return SPBUrlHelper.Action("Search", "ChannelFile", new RouteValueDictionary { { "TagName", WebUtils.UrlEncode(tagName) } });
        }

        /// <summary>
        /// 根据AttachmentID获取标题图片Url
        /// </summary>
        public static string FileFeaturedImageUrl(this SiteUrls siteUrls, int attachmentID)
        {
            return FileFeaturedImageUrl(siteUrls, attachmentID, FileFeaturedImageTypes.Original);
        }
        /// <summary>
        /// 根据AttachmentID获取标题图片Url
        /// </summary>
        public static string FileFeaturedImageUrl(this SiteUrls siteUrls, int attachmentID, FileFeaturedImageTypes imageType)
        {
            //如果启用URL直连 则直接使用直连URL
            if (FileStorageProvider.Instance(FileFeaturedImageManager.Instance().StorageProviderName).EnableDirectlyUrl)
            {
                Attachment attachment = FileFeaturedImageManager.Instance().GetAttachment(attachmentID, false);
                if (attachment == null)
                    return string.Empty;

                //默认仅预生成标题图
                if (imageType == FileFeaturedImageTypes.Original || imageType == FileFeaturedImageTypes.Title)
                    return FileFeaturedImageManager.Instance().GetDirectlyUrl(attachment, imageType);
            }
            return Globals.GetFullUrlInFileHandlerSite(FileFeaturedImageManager.Instance().StorageProviderName, string.Format("~/Services/File/FileFeaturedImage.ashx?AttachmentID={0}&imageType={1}", attachmentID, imageType));
        }
    }
}
