﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.File
{
    public class FileApplication : Application
    {
        /// <summary>
        /// 安装文件时，需要为用户创建Section
        /// </summary>
        /// <param name="presentAreaID"></param>
        /// <param name="ownerID"></param>
        public override void InstallApplication(int presentAreaID, int ownerID)
        {
            if (presentAreaID == PresentAreaIDs.Instance().UserDomain() || presentAreaID == PresentAreaIDs.Instance().CompanyUserDomain())
            {
                User user = Users.GetUser(ownerID, true);
                if (user == null)
                    return;
                FileSection section = FileSections.GetSection(user.UserID, true);
                if (section == null)
                {
                    section = new FileSection();
                    section.OwnerUserID = user.UserID;
                    section.SectionName = user.DisplayName;
                    section.IsActive = true;
                    section.DateCreated = DateTime.Now;
                    section.EnableSearch = true;

                    FileSections.Create(section);
                }
            }
        }
        /// <summary>
        /// 卸载文件时，需要处理文件相关的数据
        /// </summary>
        public override void UnInstallApplication(int presentAreaID, int ownerID)
        {
            if (presentAreaID == PresentAreaIDs.Instance().UserDomain() || presentAreaID == PresentAreaIDs.Instance().CompanyUserDomain())
            {
                FileThreads.DeleteUser(ownerID);
            }
        }
        /// <summary>
        /// 获取用户的文件统计数
        /// </summary>
        public override int GetItemCountValue(int presentAreaID, int ownerID)
        {
            int itemCount = 0;
            if (presentAreaID == PresentAreaIDs.Instance().UserDomain() || presentAreaID == PresentAreaIDs.Instance().CompanyUserDomain())
            {
                FileSection section = FileSections.GetSection(ownerID, false);
                if (section != null)
                    itemCount = section.FileCount;
            }
            return itemCount;
        }
    }
}
