//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Xml;

using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using System.Xml.Linq;


namespace SpaceBuilder.File
{
    /// <summary>
    /// ļ
    /// </summary>
    public class FileSectionConfiguration : ApplicationConfiguration
    {
        #region Public Properties

        private int _siteCategoryLevel = 1;
        /// <summary>
        /// վĲ
        /// </summary>
        public int SiteCategoryLevel
        {
            get { return _siteCategoryLevel; }
            set { _siteCategoryLevel = value; }
        }

        private bool _siteCategoryRequired = false;
        /// <summary>
        /// վǷ
        /// </summary>
        public bool SiteCategoryRequired
        {
            get { return _siteCategoryRequired; }
        }

        private bool _enableUserEntrySiteCategory = true;
        /// <summary>
        /// Ƿûվ
        /// </summary>
        public bool EableUserEntrySiteCategory
        {
            get { return _enableUserEntrySiteCategory; }
        }


        #region µ⣬ժҪݵ

        private int minLengthForTitle = 1;
        /// <summary>
        /// 
        /// </summary>
        public int MinLengthForTitle
        {
            get { return minLengthForTitle; }
            set { minLengthForTitle = value; }
        }

        private int maxLengthForTitle = 200;
        /// <summary>
        /// 
        /// </summary>
        public int MaxLengthForTitle
        {
            get { return maxLengthForTitle; }
            set { maxLengthForTitle = value; }
        }

        private int minLengthForBody = 0;
        /// <summary>
        /// 
        /// </summary>
        public int MinLengthForBody
        {
            get { return minLengthForBody; }
            set { minLengthForBody = value; }
        }

        private int maxLengthForBody = 50000;
        /// <summary>
        /// 
        /// </summary>
        public int MaxLengthForBody
        {
            get { return maxLengthForBody; }
            set { maxLengthForBody = value; }
        }


        #endregion


        private FileAttachmentSettings _fileAttachmentSettings;
        /// <summary>
        /// ļ
        /// </summary>
        public FileAttachmentSettings AttachmentSettings
        {
            get { return _fileAttachmentSettings; }
            set { _fileAttachmentSettings = value; }
        }

        private FileFeaturedImageSettings _fileFeaturedImageSettings;
        /// <summary>
        /// ļͼ
        /// </summary>
        public FileFeaturedImageSettings FeaturedImageSettings
        {
            get { return _fileFeaturedImageSettings; }
            set { _fileFeaturedImageSettings = value; }
        }

        int _rssCacheWindowInSeconds = 90;
        /// <summary>
        /// Rssʱ
        /// </summary>
        public int RssCacheWindowInSeconds
        {
            get { return _rssCacheWindowInSeconds; }
            set { _rssCacheWindowInSeconds = value; }
        }

        int _RssDefaultThreadsPerFeed = 15;
        /// <summary>
        /// RssĬÿҳļ
        /// </summary>
        public int RssDefaultThreadsPerFeed
        {
            get { return _RssDefaultThreadsPerFeed; }
            set { _RssDefaultThreadsPerFeed = value; }
        }

        private int aggregatePostCount = 25;
        /// <summary>
        /// ܼ¼
        /// </summary>
        public int AggregatePostCount
        {
            get { return aggregatePostCount; }
            set { aggregatePostCount = value; }
        }

        private bool onlyAllowRegisteredUserDownload = false;
        /// <summary>
        /// Ƿûļ
        /// </summary>
        public bool OnlyAllowRegisteredUserDownload
        {
            get { return onlyAllowRegisteredUserDownload; }
            set { onlyAllowRegisteredUserDownload = value; }
        }

        private int threadsPerPage = 10;
        /// <summary>
        /// ÿҳʾ¼
        /// </summary>
        public int ThreadsPerPage
        {
            get { return threadsPerPage; }
        }

        private int commentsPerPage = 50;
        /// <summary>
        /// ÿҳʾ¼
        /// </summary>
        public int CommentsPerPage
        {
            get { return commentsPerPage; }
        }
        private bool _forceSetTitleImage = false;
        /// <summary>
        /// ǷǿñͼûãȡеĵһͼƬΪͼ
        /// </summary>
        public bool ForceSetTitleImage
        {
            get { return _forceSetTitleImage; }
        }

        #region Popular Posts

        //int _PopularPostLevelPosts = 15;
        //public int PopularPostLevelPosts
        //{
        //    get { return _PopularPostLevelPosts; }
        //    set { _PopularPostLevelPosts = value; }
        //}

        ////int _PopularPostLevelViews = 200;
        ////public int PopularPostLevelViews
        ////{
        ////    get { return _PopularPostLevelViews; }
        ////    set { _PopularPostLevelViews = value; }
        ////}

        //int _PopularPostLevelDays = 3;
        //public int PopularPostLevelDays
        //{
        //    get { return _PopularPostLevelDays; }
        //    set { _PopularPostLevelDays = value; }
        //}

        #endregion

        #region Duplicate Posts
        bool _EnableDuplicatePosts = false;
        /// <summary>
        /// Ƿظϴļ
        /// </summary>
        public bool EnableDuplicatePosts
        {
            get { return _EnableDuplicatePosts; }
            set { _EnableDuplicatePosts = value; }
        }

        int _DuplicatePostIntervalInMinutes = 15;
        /// <summary>
        /// ظҪ೤ʱ䣨λӣ
        /// </summary>
        public int DuplicatePostIntervalInMinutes
        {
            get { return _DuplicatePostIntervalInMinutes; }
            set { _DuplicatePostIntervalInMinutes = value; }
        }

        private bool _enableAutoCreate = true;
        /// <summary>
        /// ûעᣬԶFile
        /// </summary>
        public bool EnableAutoCreate
        {
            get { return _enableAutoCreate; }
            set { _enableAutoCreate = value; }
        }

        #endregion

        #endregion

        #region Public Static Methods

        /// <summary>
        /// ļģöʾ
        /// </summary>
        /// <returns>ļģö</returns>
        public static FileSectionConfiguration Instance()
        {
            return ApplicationConfigurations.Instance().GetConfig("File") as FileSectionConfiguration;
        }

        #endregion

        /// <summary>
        /// ʼ
        /// </summary>
        public FileSectionConfiguration(XElement xElement)
            : base(xElement)
        {
            if (xElement != null)
            {
                XElement fs = xElement.Element("attachmentSettings");
                this.AttachmentSettings = Serializer.ConvertToObject<FileAttachmentSettings>(fs);

                fs = xElement.Element("featuredImageSettings");
                this.FeaturedImageSettings = Serializer.ConvertToObject<FileFeaturedImageSettings>(fs);

                XAttribute att = xElement.Attribute("aggregatePostCount");
                if (att != null)
                    int.TryParse(att.Value.ToString(), out this.aggregatePostCount);

                att = xElement.Attribute("rssCacheWindowInSeconds");
                if (att != null)
                    int.TryParse(att.Value.ToString(), out this.aggregatePostCount);

                att = xElement.Attribute("siteCategoryLevel");
                if (att != null)
                    int.TryParse(att.Value.ToString(), out this._siteCategoryLevel);
                att = xElement.Attribute("siteCategoryRequired");
                if (att != null)
                    bool.TryParse(att.Value, out _siteCategoryRequired);

                att = xElement.Attribute("forceSetTitleImage");
                if (att != null)
                    bool.TryParse(att.Value, out _forceSetTitleImage);

                att = xElement.Attribute("titleImageX");
                if (att != null)
                    int.TryParse(att.Value, out titleImageX);

                att = xElement.Attribute("titleImageY");
                if (att != null)
                    int.TryParse(att.Value, out titleImageY);

                att = xElement.Attribute("slideImageX");
                if (att != null)
                    int.TryParse(att.Value, out slideImageX);

                att = xElement.Attribute("slideImageY");
                if (att != null)
                    int.TryParse(att.Value, out slideImageY);


                att = xElement.Attribute("enableUserEntrySiteCategory");
                if (att != null)
                    bool.TryParse(att.Value, out _enableUserEntrySiteCategory);
                att = xElement.Attribute("minLengthForTitle");
                if (att != null)
                    int.TryParse(att.Value, out this.minLengthForTitle);
                att = xElement.Attribute("maxLengthForTitle");
                if (att != null)
                    int.TryParse(att.Value, out this.maxLengthForTitle);
                att = xElement.Attribute("minLengthForBody");
                if (att != null)
                    int.TryParse(att.Value, out this.minLengthForBody);
                att = xElement.Attribute("maxLengthForBody");
                if (att != null)
                    int.TryParse(att.Value, out this.maxLengthForBody);

                att = xElement.Attribute("onlyAllowRegisteredUserDownload");
                if (att != null)
                    bool.TryParse(att.Value.ToString(), out this.onlyAllowRegisteredUserDownload);
                att = xElement.Attribute("threadsPerPage");
                if (att != null)
                    int.TryParse(att.Value, out threadsPerPage);

                att = xElement.Attribute("commentsPerPage");
                if (att != null)
                    int.TryParse(att.Value, out commentsPerPage);

                att = xElement.Attribute("enableAutoCreate");
                if (att != null)
                    bool.TryParse(att.Value, out _enableAutoCreate);
            }
        }

        #region ͼƬ

        private ImageSettings titleImageSettings = null;
        /// <summary>
        /// ͼƬ
        /// </summary>
        public ImageSettings TitleImageSettings
        {
            get
            {
                if (titleImageSettings == null)
                    titleImageSettings = new ImageSettings(TitleImageX, TitleImageY, true);

                return titleImageSettings;
            }
        }

        private int titleImageX = 100;
        /// <summary>
        /// ͼƬ
        /// </summary>
        public int TitleImageX
        {
            get { return titleImageX; }
        }

        private int titleImageY = 100;
        /// <summary>
        /// ͼƬ߶
        /// </summary>
        public int TitleImageY
        {
            get { return titleImageY; }
        }

        #endregion

        #region õͼƬ

        private ImageSettings slideImageSettings = null;
        /// <summary>
        /// õͼƬ
        /// </summary>
        public ImageSettings SlideImageSettings
        {
            get
            {
                if (slideImageSettings == null)
                {
                    slideImageSettings = new ImageSettings(SlideImageX, SlideImageY, true);
                    slideImageSettings.EnabledCrop = true;
                }
                return slideImageSettings;
            }
        }

        private int slideImageX = 320;
        /// <summary>
        /// ͼƬõʾĿ
        /// </summary>
        public int SlideImageX
        {
            get { return slideImageX; }
        }

        private int slideImageY = 240;
        /// <summary>
        /// ͼƬõʾĸ߶
        /// </summary>
        public int SlideImageY
        {
            get { return slideImageY; }
        }

        #endregion

    }
}
