﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Common;
using System.IO;
using SpaceBuilder.Utils;

namespace SpaceBuilder.File
{
    /// <summary>
    /// 文件附件 业务逻辑类
    /// </summary>
    public class FileAttachmentManager : AttachmentManager
    {
        #region Instance
        private static volatile FileAttachmentManager _instance = null;
        private static readonly object lockObject = new object();

        public static FileAttachmentManager Instance()
        {
            if (_instance == null)
            {
                lock (lockObject)
                {
                    if (_instance == null)
                    {
                        _instance = new FileAttachmentManager();
                    }
                }
            }

            return _instance;
        }

        private FileAttachmentManager()
        {
        }
        #endregion

        /// <remarks>
        /// 在文件中不会用到
        /// </remarks>
        public override AttachmentDataProvider DataProvider
        {
            get { throw new NotImplementedException(); }
        }

        /// <summary>
        /// 文件存储ProviderName
        /// </summary>
        public override string StorageProviderName
        {
            get { return "FileStorage"; }
        }

        public override AttachmentSettings Settings
        {
            get { return FileSectionConfiguration.Instance().AttachmentSettings; }
        }

        /// <remarks>
        /// 在文件中不会用到
        /// </remarks>
        public override string CacheKeyPrefix
        {
            get { return "FileAttachment"; }
        }

        public override bool RequireDataBaseStorage
        {
            get { return false; }
        }


        #region Create/Delete

        /// <summary>
        ///  删除用户的所有文件
        /// </summary>
        public override void DeleteAttachmentsByOwnerID(int ownerID)
        {
            BlockPagingID blockPagingID = FileDataProvider.Instance().GetFileThreadIDs(ownerID, null, null, null, null, true, ValueHelper.GetSqlMaxInt(), ValueHelper.GetSqlMaxInt(), 1);

            //删除OwnerID的所有附件
            foreach (int associateID in blockPagingID.GetAll())
            {
                DeleteAttachmentsByAssociateID(associateID);
            }
        }

        #endregion

        #region Get & Gets

        /// <summary>
        /// 请通过FileThreads.GetThread()获取Attachment
        /// </summary>
        public override Attachment GetAttachment(int attachmentID, bool isRealTime)
        {
            FileThread fileThread = FileThreads.GetThread(attachmentID, null, isRealTime);
            if (fileThread != null)
                return fileThread.Attachment;
            else
                return null;
        }

        /// <summary>
        /// 请通过FileThreads.GetThread()获取Attachment
        /// </summary>
        /// <remarks>
        /// 该方法不会用到
        /// </remarks>
        public override List<Attachment> GetAttachmentsByAssociateID(int associateID, bool isRealTime)
        {
            FileThread fileThread = FileThreads.GetThread(associateID, null, isRealTime);
            List<Attachment> attachments = new List<Attachment>();

            if (fileThread != null)
            {
                attachments.Add(fileThread.Attachment);
            }
            return attachments;
        }

        #endregion

    }
}
