//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.File
{
    /// <summary>
    /// ļʵ
    /// </summary>
    [Serializable]
    public class FileComment : ExtendedAttributes
    {
        #region 
    
        private int postID = 0;
        /// <summary>
        /// PostID
        /// </summary>
        public int PostID
        {
            get { return postID; }
            set { postID = value; }
        }

        private int parentID = 0;
        /// <summary>
        /// ParentID
        /// </summary>
        public int ParentID
        {
            get { return parentID; }
            set
            {
                if (value < 0)
                    parentID = 0;
                else
                    parentID = value;
            }
        }

        private int threadID = 0;
        /// <summary>
        /// ThreadID
        /// </summary>
        public int ThreadID
        {
            get { return threadID; }
            set { threadID = value; }
        }

        private int ownerUserID;
        /// <summary>
        /// ļUserID
        /// </summary>
        public int OwnerUserID
        {
            get { return ownerUserID; }
            set { ownerUserID = value; }
        }

        private int userID;
        /// <summary>
        /// ûID
        /// </summary>
        public int UserID
        {
            get { return userID; }
            set { userID = value; }
        }

        private string author = string.Empty;
        /// <summary>
        /// 
        /// </summary>
        public String Author
        {
            get { return author; }
            set { author = value; }
        }


        //private string subject = string.Empty;
        ///// <summary>
        ///// 
        ///// </summary>
        //public String Subject
        //{
        //    get { return subject; }
        //    set { subject = value; }
        //}

        private string body = string.Empty;
        /// <summary>
        /// 
        /// </summary>
        public String Body
        {
            get { return body; }
            set { body = value; }
        }

        private string userHostAddress = string.Empty;
        /// <summary>
        /// ʱûIPַ
        /// </summary>
        public string UserHostAddress
        {
            get { return userHostAddress; }
            set { userHostAddress = value; }
        }

        private DateTime postDate = DateTime.MinValue;
        /// <summary>
        /// 
        /// </summary>
        public DateTime PostDate
        {
            get
            {
                if (postDate == DateTime.MinValue)
                    postDate = DateTime.Now;

                return postDate;
            }
            set { postDate = value; }
        }


        private bool isApproved = true;
        /// <summary>
        /// Ƿͨ׼
        /// </summary>
        public bool IsApproved
        {
            get { return isApproved; }
            set { isApproved = value; }
        }

        private AuditingStatuses auditingStatus;
        /// <summary>
        /// ״̬
        /// </summary>
        public AuditingStatuses AuditingStatus
        {
            get { return auditingStatus; }
            set { auditingStatus = value; }
        }

        #endregion
        

        #region л

        /// <summary>
        /// ʱύUrl
        /// </summary>
        public string TitleUrl
        {
            get { return this.GetExtendedAttribute("Website"); }
            set { this.SetExtendedAttribute("Website", value); }
        }

        /// <summary>
        /// Ƿļ
        /// </summary>
        public bool HasTitleUrl
        {
            get { return (TitleUrl != null && TitleUrl.Length > 0); }
        }

        /// <summary>
        /// ύû
        /// </summary>
        public string SubmittedUserName
        {
            get { return GetString("Name", null); }
            set { this.SetExtendedAttribute("Name", value); }
        }

        /// <summary>
        /// Ƿύû
        /// When the post was saved, did the user submit a different name
        /// </summary>
        public bool HasSubmittedUserName
        {
            get { return !string.IsNullOrEmpty(this.SubmittedUserName); }
        }

        #endregion

        #region л

        /// <summary>
        /// ظûID
        /// </summary>
        public int ParentUserID
        {
            get { return GetInt("ParentUserID", 0); }
            set { SetExtendedAttribute("ParentUserID", value.ToString()); }
        }

        /// <summary>
        /// ظ˵
        /// </summary>
        public string ParentAuthor
        {
            get { return GetString("ParentAuthor", string.Empty); }
            set { SetExtendedAttribute("ParentAuthor", value); }
        }

        /// <summary>
        /// ظ۵
        /// </summary>
        public string ParentBody
        {
            get { return GetString("ParentBody", string.Empty); }
            set { SetExtendedAttribute("ParentBody", value); }
        }

        /// <summary>
        /// ظʱ
        /// </summary>
        public DateTime ParentPostDate
        {
            get { return Convert.ToDateTime(GetString("ParentPostDate", DateTime.MinValue.ToString())); }
            set { SetExtendedAttribute("ParentPostDate", value.ToString()); }
        }

        #endregion

        
    }
}
