﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.File
{
    /// <summary>
    /// 文件下载记录
    /// </summary>
    [Serializable]
    public class FileDownLoadRecord : SPBEntity
    {
        private int recordID;
        /// <summary>
        /// 记录ID
        /// </summary>
        public int RecordID
        {
            get { return recordID; }
            set { recordID = value; }
        }

        private int userID;
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserID
        {
            get { return userID; }
            set { userID = value; }
        }
        private int threadID;
        /// <summary>
        /// 文件ID
        /// </summary>
        public int ThreadID
        {
            get { return threadID; }
            set { threadID = value; }
        }
        private string userDisplayName = string.Empty;
        /// <summary>
        /// 下载者
        /// </summary>
        public string UserDisplayName
        {
            get { return userDisplayName; }
            set { userDisplayName = value; }
        }

        private int price = 0;
        /// <summary>
        /// 消费的金币
        /// </summary>
        public int Price
        {
            get { return price; }
            set { price = value; }
        }
        private DateTime dateCreated = DateTime.Now;
        /// <summary>
        /// 下载日期
        /// </summary>
        public DateTime DateCreated
        {
            get { return dateCreated; }
            set { dateCreated = value; }
        }

        private string userHostAddress = "000.000.000.000";

        /// <summary>
        /// 用户IP
        /// </summary>
        public string UserHostAddress
        {
            get { return userHostAddress; }
            set { userHostAddress = value; }
        }

        private string fromUrl;
        /// <summary>
        /// 下载请求来源Url
        /// </summary>
        public string FromUrl
        {
            get { return fromUrl; }
            set { fromUrl = value; }
        }
    }
}
