//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using SpaceBuilder.Common;



namespace SpaceBuilder.File
{
    /// <summary>
    /// ļģʵ
    /// </summary>
    [Serializable]
    public class FileSection : ExtendedAttributes
    {
        #region 

        private int ownerUserID;
        /// <summary>
        /// ļUserID
        /// </summary>
        public int OwnerUserID
        {
            get { return ownerUserID; }
            set { ownerUserID = value; }
        }

        private string sectionName = string.Empty;
        /// <summary>
        /// SectionName
        /// </summary>
        public string SectionName
        {
            get { return sectionName; }
            set { sectionName = value; }
        }


        private string description = string.Empty;
        /// <summary>
        /// 
        /// </summary>
        public string Description
        {
            get { return description; }
            set { description = value; }
        }

        private bool isActive = true;
        /// <summary>
        /// Ƿ񼤻
        /// </summary>
        public bool IsActive
        {
            get { return isActive; }
            set { isActive = value; }
        }

        private bool enableSearch = true;
        /// <summary>
        /// 
        /// </summary>
        public bool EnableSearch
        {
            get { return enableSearch; }
            set { enableSearch = value; }
        }

        private DateTime dateCreated = DateTime.MinValue;
        /// <summary>
        /// 
        /// </summary>
        public DateTime DateCreated
        {
            get
            {
                if (dateCreated == DateTime.MinValue)
                    dateCreated = DateTime.Now;

                return dateCreated;
            }
            set { dateCreated = value; }
        }


        private DateTime mostRecentPostDate = DateTime.MinValue;
        /// <summary>
        /// 
        /// </summary>
        public DateTime MostRecentPostDate
        {
            get
            {
                if (mostRecentPostDate == DateTime.MinValue)
                    mostRecentPostDate = DateTime.Now;

                return mostRecentPostDate;
            }
            set { mostRecentPostDate = value; }
        }

        private int mostRecentThreadID = 0;
        /// <summary>
        /// ·ID
        /// </summary>
        public int MostRecentThreadID
        {
            get { return mostRecentThreadID; }
            set { mostRecentThreadID = value; }
        }

        private string mostRecentThreadSubject = string.Empty;
        /// <summary>
        /// ļ
        /// </summary>
        public string MostRecentThreadSubject
        {
            get { return mostRecentThreadSubject; }
            set { mostRecentThreadSubject = value; }
        }

        private string mostRecentThreadSummary = string.Empty;
        /// <summary>
        /// ļ
        /// </summary>
        public string MostRecentThreadSummary
        {
            get { return mostRecentThreadSummary; }
            set { mostRecentThreadSummary = value; }
        }


        #endregion


        #region ͳ

        private int fileCount;
        /// <summary>
        /// ļ
        /// </summary>
        public int FileCount
        {
            get { return this.fileCount; }
            set { this.fileCount = value; }
        }

        private int commentCount;
        /// <summary>
        /// 
        /// </summary>
        public int CommentCount
        {
            get { return this.commentCount; }
            set { this.commentCount = value; }
        }

        private int points = 0;
        /// <summary>
        /// 
        /// </summary>
        public int Points
        {
            get { return points; }
            set { points = value; }
        }

        private int hitTimes = 0;
        /// <summary>
        /// 
        /// </summary>
        public int HitTimes
        {
            get { return this.hitTimes; }
            set { this.hitTimes = value; }
        }

        private int stageHitTimes = 0;
        /// <summary>
        /// 
        /// </summary>
        public int StageHitTimes
        {
            get { return this.stageHitTimes; }
            set { this.stageHitTimes = value; }
        }

        private int downloadFileCount = 0;
        /// <summary>
        /// ؼ
        /// </summary>
        public int DownloadFileCount
        {
            get { return this.downloadFileCount; }
            set { this.downloadFileCount = value; }
        }
        #endregion

        /// <summary>
        /// ļû<seealso cref="SpaceBuilder.Common.User"/>
        /// </summary>
        public User Owner
        {
            get
            {
                return Users.GetUser(OwnerUserID, false);
            }
        }

        #region Feature Settings

        ///// <summary>
        ///// ǷվʹRSS
        ///// </summary>
        //public bool EnableRssSyndication
        //{
        //    get
        //    {
        //        string val = GetExtendedAttribute("EnableRssSyndication");
        //        if (val != string.Empty)
        //            return bool.Parse(val);
        //        else
        //            return true;
        //    }
        //    set { SetExtendedAttribute("EnableRssSyndication", value.ToString()); }
        //}

        ///// <summary>
        ///// ǷñǩRSS
        ///// </summary>
        //public bool EnableTagsRss
        //{
        //    get
        //    {
        //        string val = GetExtendedAttribute("EnableTagsRss");
        //        if (val != string.Empty)
        //            return bool.Parse(val);
        //        else
        //            return true;
        //    }
        //    set { SetExtendedAttribute("EnableTagsRss", value.ToString()); }
        //}

        ///// <summary>
        ///// ǷʹǼ
        ///// </summary>
        //public bool EnableRatings
        //{
        //    get
        //    {
        //        string val = GetExtendedAttribute("EnableRatings");
        //        if (val != string.Empty)
        //            return bool.Parse(val);
        //        else
        //            return true;
        //    }
        //    set { SetExtendedAttribute("EnableRatings", value.ToString()); }
        //}

        ///// <summary>
        ///// Ƿãͬһ
        ///// </summary>
        //public bool EnableDisclaimer
        //{
        //    get
        //    {
        //        string val = GetExtendedAttribute("EnableDisclaimer");
        //        if (val != string.Empty)
        //            return bool.Parse(val);
        //        else
        //            return false;
        //    }
        //    set { SetExtendedAttribute("EnableDisclaimer", value.ToString()); }
        //}

        /// <summary>
        /// Ƿ
        /// </summary>
        public bool EnableComments
        {
            get
            {
                string val = GetExtendedAttribute("EnableComments");
                if (val != string.Empty)
                    return bool.Parse(val);
                else
                    return true;
            }
            set { SetExtendedAttribute("EnableComments", value.ToString()); }
        }

        /// <summary>
        /// ǷҪ
        /// </summary>
        public bool ModerateComments
        {
            get
            {
                string val = GetExtendedAttribute("ModerateComments");
                if (val != string.Empty)
                    return bool.Parse(val);
                else
                    return false;
            }
            set { SetExtendedAttribute("ModerateComments", value.ToString()); }
        }

        /// <summary>
        /// Ƿ֪ͨ
        /// </summary>
        public bool EnableCommentNotification
        {
            get
            {
                string val = GetExtendedAttribute("EnableCommentNotification");
                if (val != string.Empty)
                    return bool.Parse(val);
                else
                    return false;
            }
            set { SetExtendedAttribute("EnableCommentNotification", value.ToString()); }
        }

        /// <summary>
        /// Ƿظ
        /// </summary>
        public bool EnableAnonymousPosting
        {
            get { return GetBool("EnableAnonymousPosting", true); }
            set { SetExtendedAttribute("EnableAnonymousPosting", value.ToString()); }
        }

        /// <summary>
        /// Ĭϵ״̬
        /// </summary>
        public PrivacyStatuses DefaultPrivacyStatus
        {
            get { return (PrivacyStatuses)Enum.Parse(typeof(PrivacyStatuses), GetString("PrivacyStatus", "Public"), false); }
            set { SetExtendedAttribute("PrivacyStatus", value.ToString()); }
        }


        /// <summary>
        /// Ĭ
        /// </summary>
        public string DefaultPrivacyPassword
        {
            get { return GetString("Password", string.Empty); }
            set { SetExtendedAttribute("Password", value); }
        }

        #endregion


        /// <summary>
        /// Ƿĳû
        /// </summary>
        public bool EnableNewComments(User user)
        {
            //if (!Permissions.ValidatePermissions(this, Permission.Reply, user))
            //    return false;

            if (!EnableComments)
                return false;

            //if (user.IsAnonymous && (!SiteSettingsManager.GetSiteSettings().EnableAnonymousUserPosting))
            //    return false;

            return true;
        }

    }
}
