﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.File
{
    /// <summary>
    ///FileSection计数器
    /// </summary>
    ///<remarks>
    ///用于计算FileSection的点击计数
    /// </remarks>
    public class FileSectionCounter : Counter
    {
        /// <summary>
        /// 把当前队列中的浏览计数更新到数据库
        /// </summary>
        public override int ExecQueue()
        {
            Dictionary<int, int> countObjects = DequeueIncreaseCounts(IncreasableCountTypes.WebView);
            FileDataProvider.Instance().SaveFileSectionCounterQueue(countObjects);
            List<int> reCounts = DequeueReCounts();
            FileDataProvider.Instance().ExecFileSectionResetStatistics(reCounts);
            return countObjects.Count + reCounts.Count;
        }
    }
}
