//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Caching;

namespace SpaceBuilder.File
{
    /// <summary>
    /// ļģҵ߼
    /// </summary>
    public static class FileSections
    {

        #region Create/Update/Delete

        /// <summary>
        /// ļģ
        /// </summary>
        public static void Create(FileSection section)
        {
            FileEvents.BeforeFileSectionChange(section, ObjectState.Create);

            FileDataProvider.Instance().CreateUpdateSection(section, DataProviderAction.Create);

            CacheRepository.Add(GetCacheKey_SingleFileSection(section.OwnerUserID), section, CachingExpirationTypes.SingleObject);

            FileEvents.AfterFileSecionChange(section, ObjectState.Create);

        }

        /// <summary>
        /// ļģ
        /// </summary>
        /// <param name="section">Ҫµļģ</param>
        /// <returns>ļģSectionID</returns>
        public static void Update(FileSection section)
        {
            FileEvents.BeforeFileSectionChange(section, ObjectState.Update);

            FileDataProvider.Instance().CreateUpdateSection(section, DataProviderAction.Update);

            //»
            CacheRepository.AddOrReplace(GetCacheKey_SingleFileSection(section.OwnerUserID), section, CachingExpirationTypes.SingleObject);

            FileEvents.AfterFileSecionChange(section, ObjectState.Update);
        }

        /// <summary>
        /// ɾĳļģ
        /// </summary>
        /// <param name="ownerUserID">OwnerUserID</param>
        public static void Delete(int ownerUserID)
        {
            //FileSection fileSection = GetSection(ownerUserID,true);

            // We first need the gallery, to do a few things
            FileSection fileSection = GetSection(ownerUserID,true);

            #region ɾ
            FileAttachmentManager.Instance().DeleteAttachmentsByOwnerID(ownerUserID);
            #endregion

            FileEvents.BeforeFileSectionChange(fileSection, ObjectState.Delete);

            // Delete the FileSection in the database            
            FileDataProvider.Instance().DeleteSection(ownerUserID);

            FileEvents.AfterFileSecionChange(fileSection, ObjectState.Delete);

            //
            fileSection.IsDeletedInDataBase = true;
            CacheRepository.MarkDeletion(GetCacheKey_SingleFileSection(fileSection.OwnerUserID), fileSection, CachingExpirationTypes.SingleObject);

        }

        #endregion

        #region Get & Gets

        /// <summary>
        /// SectionIDȡļģʵ壬Ƿʹû
        /// </summary>
        /// <param name="sectionID">ļģID</param>
        /// <param name="userCache">Ƿʹû</param>
        /// <returns>ļģʵ</returns>
        public static FileSection GetSection(int ownerUserID, bool isRealTime)
        {
            string cacheKey = GetCacheKey_SingleFileSection(ownerUserID);

            FileSection section = CacheRepository.Get(cacheKey, isRealTime) as FileSection;

            if (section == null)
            {
                section = FileDataProvider.Instance().GetSection(ownerUserID);
                CacheRepository.Add(cacheKey, section, CachingExpirationTypes.UsualSingleObject);
            }

            return section==null ? null:(section.IsDeletedInDataBase?null:section);
        }

        /// <summary>
        /// ȡʽǰtopNumberļ
        /// </summary>
        /// <remarks>
        /// ҪƵҳ
        /// </remarks>
        public static IList<FileSection> GetTopSectionsSortBy(FileSectionSortBy sortBy, int topNumber)
        {
            BlockPagingID blockPagingID = GetSectionIDsSortBy(sortBy);
            return PopulateFileSectionsFromIDs(blockPagingID.GetTopIDs(topNumber),false);
        }

        /// <summary>
        /// ҳȡʽFileSection
        /// </summary>
        /// <remarks>
        /// ҪƵ
        /// </remarks>
        /// <param name="sortBy"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public static PagingDataSet<FileSection> GetPagingSectionsSortBy(FileSectionSortBy sortBy, int pageSize, int pageIndex)
        {
            BlockPagingID blockPagingID = GetSectionIDsSortBy(sortBy);
            IList<FileSection> fileSections = PopulateFileSectionsFromIDs(blockPagingID.GetPagingIDs(pageSize, pageIndex),false);

            PagingDataSet<FileSection> pagingFileSections = new PagingDataSet<FileSection>(fileSections);
            pagingFileSections.PageIndex = pageIndex;
            pagingFileSections.PageSize = pageSize;
            pagingFileSections.TotalRecords = blockPagingID.Count;

            return pagingFileSections;
        }


        /// <summary>
        /// ȡʽFileThreadID
        /// </summary>
        /// <param name="sortBy">ʽ</param>
        private static BlockPagingID GetSectionIDsSortBy(FileSectionSortBy sortBy)
        {
            string cacheKey = string.Format("FileSectionIDsSortBy:{0}", (int)sortBy);

            BlockPagingID blockPagingID = CacheRepository.Get(cacheKey, false) as BlockPagingID;

            if (blockPagingID == null)
            {
                Application fileApplication = Applications.GetApplication(ApplicationIDs.Instance().File());
                blockPagingID = FileDataProvider.Instance().GetFileSectionIDsSortBy(sortBy, FileSectionConfiguration.Instance().SecondaryMaxRecords, FileActiveStatus.IsActive, true);
                CacheRepository.Add(cacheKey, blockPagingID, CachingExpirationTypes.UsualObjectCollection);
            }

            return blockPagingID;
        }


        /// <summary>
        /// ȡƶҳĺѵļ
        /// </summary>
        public static PagingDataSet<FileSection> GetFirendRecentFileThreads(int userID, int pageIndex, int pageSize)
        {
            string cacheKey = string.Format("FileSectionIDs::MyFriend:{0}", userID);

            BlockPagingID blockPagingID = CacheRepository.Get(cacheKey, false) as BlockPagingID;

            if (blockPagingID == null)
            {
                blockPagingID = FileDataProvider.Instance().GetFileSectionIDsOfFriends(userID);
                CacheRepository.Add(cacheKey, blockPagingID, CachingExpirationTypes.ObjectCollection);
            }

            IList<FileSection> fileSections = PopulateFileSectionsFromIDs(blockPagingID.GetPagingIDs(pageSize, pageIndex),false);

            PagingDataSet<FileSection> pagingFileSections = new PagingDataSet<FileSection>(fileSections);
            pagingFileSections.PageIndex = pageIndex;
            pagingFileSections.PageSize = pageSize;
            pagingFileSections.TotalRecords = blockPagingID.Count;

            return pagingFileSections;
        }


        #endregion

        #region Help Methods

        /// <summary>
        /// ͨownerUserIDIList<FileSection>
        /// </summary>
        private static IList<FileSection> PopulateFileSectionsFromIDs(List<int> ownerUserIDs, bool isRealTime)
        {
            IList<FileSection> fileSections = new List<FileSection>();

            foreach (int ownerUserID in ownerUserIDs)
            {
                FileSection fileSection = GetSection(ownerUserID,isRealTime);
                if (fileSection != null)
                    fileSections.Add(fileSection);
            }
            return fileSections;
        }

        /// <summary>
        /// ȡfileSectionCacheKey
        /// </summary>
        /// <param name="ownerUserID"></param>
        /// <returns></returns>
        private static string GetCacheKey_SingleFileSection(int ownerUserID)
        {
            return "FileSection:OID:" + ownerUserID;
        }


        #endregion

    }
}
