//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;





namespace SpaceBuilder.File
{
    /// <summary>
    /// ļʵ
    /// </summary>
    [Serializable]
    public class FileThread : ExtendedAttributes, IRateable
    {

        #region Custom Properties

        private int threadID = 0;
        /// <summary>
        /// ThreadID
        /// </summary>
        public int ThreadID
        {
            get { return threadID; }
            set { threadID = value; }
        }

        private int ownerUserID;
        /// <summary>
        /// ļUserID
        /// </summary>
        public int OwnerUserID
        {
            get { return ownerUserID; }
            set { ownerUserID = value; }
        }

        /// <summary>
        /// ļû
        /// </summary>
        public User OwnerUser
        {
            get { return Users.GetUser(OwnerUserID, false); }
        }

        private string author = string.Empty;
        /// <summary>
        /// 
        /// </summary>
        public String Author
        {
            get { return author; }
            set { author = value; }
        }

        private AuditingStatuses auditingStatus;
        /// <summary>
        /// ״̬
        /// </summary>
        public AuditingStatuses AuditingStatus
        {
            get { return auditingStatus; }
            set { auditingStatus = value; }
        }

        private string subject = string.Empty;
        /// <summary>
        /// 
        /// </summary>
        public string Subject
        {
            get
            {
                if (!string.IsNullOrEmpty(subject))
                    return subject;
                else
                    return FileName;
            }
            set { subject = value; }
        }

        [NonSerialized()]
        private string body = string.Empty;
        /// <summary>
        /// 
        /// </summary>
        public string BodyForDataTransmission
        {
            get { return body; }
            set { body = value; }
        }

        private string summary = string.Empty;

        /// <summary>
        /// ժҪ(ȫļ)
        /// </summary>
        public string Summary
        {
            get
            {
                if (string.IsNullOrEmpty(summary))
                    summary = HtmlUtils.TrimHtml(this.GetBody(false), 100);
                return summary;
            }
            set { summary = value; }
        }

        private string userHostAddress = string.Empty;
        /// <summary>
        /// ʱûIPַ
        /// </summary>
        public string UserHostAddress
        {
            get { return userHostAddress; }
            set { userHostAddress = value; }
        }

        private DateTime postDate = DateTime.MinValue;
        /// <summary>
        /// 
        /// </summary>
        public DateTime PostDate
        {
            get
            {
                if (postDate == DateTime.MinValue)
                    postDate = DateTime.Now;

                return postDate;
            }
            set { postDate = value; }
        }

        private DateTime lastRepliedDate = DateTime.MinValue;
        /// <summary>
        /// ظ
        /// </summary>
        public DateTime LastRepliedDate
        {
            get { return lastRepliedDate; }
            set { lastRepliedDate = value; }
        }

        private bool isEssential = false;
        /// <summary>
        /// ǷΪ
        /// </summary>
        public bool IsEssential
        {
            get { return isEssential; }
            set { isEssential = value; }
        }

        private int specialOrder = 0;
        /// <summary>
        /// 
        /// </summary>
        public int SpecialOrder
        {
            get { return specialOrder; }
            set { specialOrder = value; }
        }

        private DateTime stickyDate = DateTime.MinValue;
        /// <summary>
        /// 
        /// </summary>
        public DateTime StickyDate
        {
            get { return stickyDate; }
            set { stickyDate = value; }
        }

        private bool isLocked = false;
        /// <summary>
        /// Ƿ
        /// </summary>
        public bool IsLocked
        {
            get { return isLocked; }
            set { isLocked = value; }
        }

        private PrivacyStatuses privacyStatus = PrivacyStatuses.Public;
        /// <summary>
        /// Ƿ񹫿
        /// </summary>
        public PrivacyStatuses PrivacyStatus
        {
            get { return privacyStatus; }
            set { privacyStatus = value; }
        }

        private string password = string.Empty;
        /// <summary>
        /// 鿴
        /// </summary>
        public string Password
        {
            get { return password; }
            set { password = value; }
        }

        private int price = 0;
        /// <summary>
        /// ۼ
        /// </summary>
        public int Price
        {
            get { return price; }
            set { price = value; }
        }

        private int userCategoryID;
        /// <summary>
        /// ûID
        /// </summary>
        public int UserCategoryID
        {
            get { return userCategoryID; }
            set { userCategoryID = value; }
        }

        private int siteCategoryID = -1;
        /// <summary>
        /// վID
        /// </summary>
        public int SiteCategoryID
        {
            get { return siteCategoryID; }
            set { siteCategoryID = value; }
        }

        #endregion

        #region IRateable Ա

        private int ratingSum = 0;
        /// <summary>
        /// ۻ
        /// </summary>
        public int RatingSum
        {
            get { return ratingSum; }
            set { ratingSum = value; }
        }

        private int totalRatings = 0;
        /// <summary>
        /// 
        /// </summary>
        public int TotalRatings
        {
            get { return totalRatings; }
            set { totalRatings = value; }
        }

        /// <summary>
        /// ƽֵ
        /// </summary>
        public double RatingAverage
        {
            get
            {
                if (TotalRatings == 0)
                    return 0;

                return ((double)RatingSum / (double)TotalRatings);
            }
        }

        /// <summary>
        /// б
        /// </summary>
        public System.Collections.IList Ratings(int topNumber)
        {
            return FileThreads.GetRatings(this.ThreadID, topNumber);
        }

        #endregion

        #region Attachment 

        private Attachment attachment = null;
        /// <summary>
        /// 
        /// </summary>
        /// <remarks>ΪֵʱΪFileThreadֵΪAttachmentFileName</remarks>
        public Attachment Attachment
        {
            get { return attachment; }
            set
            {
                attachment = value;

                attachment.OwnerID = this.OwnerUserID;
                attachment.UserID = this.OwnerUserID;
                attachment.AssociateID = this.ThreadID;
                attachment.AttachmentID = this.ThreadID;
            }
        }

        ///// <summary>
        ///// ļ
        ///// This property defines the ContentType for the image, such as "image/jpeg" or "image/gif".
        ///// </summary>
        //public string ContentType
        //{
        //    get
        //    {
        //        if (attachment != null)
        //            return attachment.ContentType;
        //        else
        //            return string.Empty;
        //    }
        //}

        #endregion

        #region ͳ

        private int commentCount = 0;
        /// <summary>
        /// ظ
        /// </summary>
        public int CommentCount
        {
            get { return commentCount; }
            set { commentCount = value; }
        }

        private int downloadCount = 0;
        /// <summary>
        /// ش
        /// </summary>
        public int DownloadCount
        {
            get { return downloadCount; }
            set { downloadCount = value; }
        }

        private int hitTimes = 0;
        /// <summary>
        /// 
        /// </summary>
        public int HitTimes
        {
            get { return hitTimes; }
            set { hitTimes = value; }
        }
        private int stageHitTimes = 0;
        /// <summary>
        /// ׶
        /// </summary>
        public int StageHitTimes
        {
            get { return stageHitTimes; }
            set { stageHitTimes = value; }
        }
        private int stageDownloadCount = 0;
        /// <summary>
        /// ׶
        /// </summary>
        public int StageDownloadCount
        {
            get { return stageDownloadCount; }
            set { stageDownloadCount = value; }
        }

        private int rssViewTimes = 0;
        /// <summary>
        /// RSS
        /// </summary>
        public int RssViewTimes
        {
            get { return rssViewTimes; }
            set { rssViewTimes = value; }
        }

        #endregion

        #region PreAndNext

        private int prevThreadID = 0;
        public int PrevThreadID
        {
            get { return prevThreadID; }
            set { prevThreadID = value; }
        }

        private string prevThreadSubject = string.Empty;
        public string PrevThreadSubject
        {
            get { return prevThreadSubject; }
            set { prevThreadSubject = value; }
        }

        private int nextThreadID = 0;
        public int NextThreadID
        {
            get { return nextThreadID; }
            set { nextThreadID = value; }
        }

        private string nextThreadSubject = string.Empty;
        public string NextThreadSubject
        {
            get { return nextThreadSubject; }
            set { nextThreadSubject = value; }
        }

        #endregion

        #region ص

        private string fileName = string.Empty;
        /// <summary>
        /// ʵʴ洢ļ
        /// </summary>
        public string FileName
        {
            get { return fileName; }
            set { fileName = value; }
        }

        private int height = 0;
        /// <summary>
        /// ͼƬ߶
        /// </summary>
        public int Height
        {
            get { return height; }
            set { height = value; }
        }

        private int width = 0;
        /// <summary>
        /// ͼƬ
        /// </summary>
        public int Width
        {
            get { return width; }
            set { width = value; }
        }

        private string contentType;
        /// <summary>
        /// ļ
        /// </summary>
        public string ContentType
        {
            get { return contentType; }
            set { contentType = value; }
        }

        private long contentSize;
        /// <summary>
        /// ļС
        /// </summary>
        public long ContentSize
        {
            get { return contentSize; }
            set { contentSize = value; }
        }

        private bool isRemote = false;
        /// <summary>
        /// ǷԶļ
        /// </summary>
        public bool IsRemote
        {
            get { return isRemote; }
            set { isRemote = value; }
        }

        #endregion

        #region  & л

        /// <summary>
        /// Ƿ
        /// </summary>
        public bool EnableComments
        {
            get
            {
                string val = GetExtendedAttribute("EnableComments");
                if (val != string.Empty)
                    return bool.Parse(val);
                else
                    return FileSections.GetSection(this.OwnerUserID, true).EnableComments;
            }
            set { SetExtendedAttribute("EnableComments", value.ToString()); }
        }

        /// <summary>
        /// ļǷ֪ͨ
        /// </summary>
        public bool EnableCommentNotification
        {
            get
            {
                string val = GetExtendedAttribute("EnableCommentNotification");
                if (val != string.Empty)
                    return bool.Parse(val);
                else
                    return FileSections.GetSection(this.OwnerUserID, true).EnableCommentNotification;
            }
            set { SetExtendedAttribute("EnableCommentNotification", value.ToString()); }
        }

        /// <summary>
        /// Url
        /// </summary>
        public string CorrelativeURL
        {
            get
            {
                string val = GetString("CorrelativeURL", string.Empty);
                return val;
            }
            set { SetExtendedAttribute("CorrelativeURL", value.ToString()); }
        }

        /// <summary>
        /// Ƿעû
        /// </summary>
        public bool OnlyAllowRegisteredUserDownload
        {
            get { return GetBool("OnlyAllowRegisteredUserDownload", FileSectionConfiguration.Instance().OnlyAllowRegisteredUserDownload); }
            set { SetExtendedAttribute("OnlyAllowRegisteredUserDownload", value.ToString()); }
        }
        /// <summary>
        /// ûõı־ͼƬ
        /// </summary>
        public int UserFeaturedImageAttachmentID
        {
            get { return GetInt("UserFeaturedImageAttachmentID", -1); }
            set { SetExtendedAttribute("UserFeaturedImageAttachmentID", value.ToString()); }
        }

        ///// <summary>
        ///// ԱõĲ±־ͼƬ
        ///// </summary>
        //public int ManagerFeaturedImageAttachmentID
        //{
        //    get
        //    {
        //        int attachmentID = GetInt("ManagerFeaturedImageAttachmentID", -1);
        //        if (attachmentID <= 0)
        //            attachmentID = this.UserFeaturedImageAttachmentID;

        //        return attachmentID;
        //    }
        //    set { SetExtendedAttribute("ManagerFeaturedImageAttachmentID", value.ToString()); }
        //}
        #endregion

        #region չ

        /// <summary>
        ///  û
        /// </summary>
        public UserCategory UserCategory
        {
            get
            {
                if (this.UserCategoryID > 0)
                    return UserCategoryManager.Instance(UserCategoryItemKeys.Instance().File()).GetUserCategory(this.UserCategoryID, false);
                else
                    return null;
            }
        }

        /// <summary>
        ///  վ
        /// </summary>
        public SiteCategory SiteCategory
        {
            get
            {
                if (this.SiteCategoryID > 0)
                    return SiteCategories.Instance(ApplicationIDs.Instance().File()).Get(this.SiteCategoryID, false);
                else
                    return null;
            }
        }


        private List<string> userTagNames = null;
        /// <summary>
        /// ڸTag
        /// </summary>
        public List<string> UserTagNames
        {
            get { return userTagNames; }
            set { userTagNames = value; }
        }

        /// <summary>
        /// ûļǩ
        /// </summary>
        public List<string> UserTags
        {
            get
            {
                return UserTagManager.Instance(UserTagItemKeys.Instance().File()).GetUserTagsOfItem(this.ThreadID, false);
            }
        }


        /// <summary>
        /// ļļģ
        /// </summary>
        public FileSection Section
        {
            get
            {
                return FileSections.GetSection(this.OwnerUserID, false);
            }
        }

        ///// <summary>
        ///// Ԥ
        ///// </summary>
        //public string PreviewBody
        //{
        //    get { return HtmlUtils.StripForPreview(this.Body); }
        //}


        #endregion


        #region Get Body

        /// <summary>
        /// ༭ʱBody
        /// </summary>
        /// <returns></returns>
        public string GetBodyForEdit()
        {
            string editedBody = FileDataProvider.Instance().GetFileThreadBody(threadID);
            if (string.IsNullOrEmpty(editedBody))
                editedBody = body;
            return editedBody;
        }

        /// <summary>
        /// Body
        /// </summary>
        public string GetBody(bool isRealTime)
        {
            return FileThreads.GetBody(threadID, isRealTime);
        }

        #endregion

    }
}
