﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.File
{
    /// <summary>
    ///文件计数器
    /// </summary>
    ///<remarks>
    ///用于计算文件的点击计数
    /// </remarks>
    public class FileThreadCounter : Counter
    {
        /// <summary>
        /// 把当前队列中的浏览计数更新到数据库
        /// </summary>
        public override int ExecQueue()
        {
            Dictionary<int, int> webViewCounts = DequeueIncreaseCounts(IncreasableCountTypes.WebView);
            Dictionary<int, int> rssViewCounts = DequeueIncreaseCounts(IncreasableCountTypes.RssView);
            Dictionary<int, int> downloadCounts = DequeueIncreaseCounts(IncreasableCountTypes.Download);
            FileDataProvider.Instance().SaveFileThreadCounterQueue(rssViewCounts, webViewCounts, downloadCounts);
            return webViewCounts.Count + rssViewCounts.Count + downloadCounts.Count;
        }
    }
}
