﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.File
{
    /// <summary>
    /// 文件事件
    /// </summary>
    public static class FileEvents
    {
        /// <summary>
        /// 添加、修改、删除文件，持久化以前触发的事件
        /// </summary>
        public static void BeforeFileThreadChange(FileThread fileThread, ObjectState state)
        {
            try
            {
                FileEventManager.Instance().ExecuteBeforeFileThreadChangeEvents(fileThread, state);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行添加、修改、删除文件，持久化以前触发的事件时出现错误", e);
            }
        }

        /// <summary>
        /// 添加、修改、删除文件，持久化以后触发的事件
        /// </summary>
        public static void AfterFileThreadChange(FileThread fileThread, ObjectState state)
        {
            try
            {
                FileEventManager.Instance().ExecuteAfterFileThreadChangeEvents(fileThread, state);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行添加、修改、删除文件，持久化以后触发的事件时出现错误", e);
            }
        }

        /// <summary>
        /// 文件设为精华，持久化以后触发的事件
        /// </summary>
        public static void AfterFileThreadSetEssential(FileThread fileThread, ObjectState state)
        {
            try
            {
                FileEventManager.Instance().ExecuteAfterFileThreadSetEssentialEvents(fileThread, state);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行文件设为精华，持久化以后触发的事件时出现错误", e);
            }
        }

        /// <summary>
        /// 文件置顶，持久化以后触发的事件
        /// </summary>
        public static void AfterFileThreadSetSticky(FileThread fileThread, ObjectState state)
        {
            try
            {
                FileEventManager.Instance().ExecuteAfterFileThreadSetStickyEvents(fileThread, state);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行文件置顶，持久化以后触发的事件时出现错误", e);
            }
        }

        /// <summary>
        /// 添加、修改、删除文件评论，持久化以前触发的事件
        /// </summary>
        public static void BeforeFilePostChange(FileComment filePost, ObjectState state)
        {
            try
            {
                FileEventManager.Instance().ExecuteBeforeFileCommentChangeEvents(filePost, state);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行添加、修改、删除文件评论，持久化以前触发的事件时出现错误", e);
            }
        }

        /// <summary>
        /// 添加、修改、删除文件评论，持久化以后触发的事件
        /// </summary>
        public static void AfterFilePostChange(FileComment filePost, ObjectState state)
        {
            try
            {
                FileEventManager.Instance().ExecuteAfterFileCommentChangeEvents(filePost, state);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行添加、修改、删除文件评论，持久化以后触发的事件时出现错误", e);
            }
        }

        /// <summary>
        /// 添加、修改、删除文件模块，持久化之前触发的事件
        /// </summary>
        public static void BeforeFileSectionChange(FileSection fileSection, ObjectState state)
        {
            try
            {
                FileEventManager.Instance().ExecuteBeforeFileSectionChangeEvents(fileSection, state);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行添加、修改、删除文件模块，持久化之前触发的事件时出现错误", e);
            }
        }

        /// <summary>
        ///添加、修改、删除文件模块，持久化以后触发的事件
        /// </summary>
        public static void AfterFileSecionChange(FileSection fileSecion, ObjectState state)
        {
            try
            {
                FileEventManager.Instance().ExecuteAfterFileSectionChangeEvents(fileSecion, state);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行添加、修改、删除文件模块，持久化以后触发的事件时出现错误", e);
            }
        }

        /// <summary>
        ///文件下载记录持久化以后触发的事件
        /// </summary>
        public static void AfterFileDownLoadRecordChange(FileDownLoadRecord record)
        {
            try
            {
                FileEventManager.Instance().ExecuteAfterFileDownLoadRecordChangeEvents(record);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行文件下载记录持久化以后触发的事件时出现错误", e);
            }
        }

        /// <summary>
        /// 文件积分变化并在持久化之后触发事件
        /// </summary>
        public static void AfterPointChangeOfFileThread(FileThread fileThread, ObjectState state, UserPointDirection userPointDirection)
        {
            try
            {
                FileEventManager.Instance().ExecutePointChangeOfFileThreadEvents(fileThread, state, userPointDirection);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行文件积分变化并在持久化之后触发事件时出现错误", e);
            }
        }

        /// <summary>
        /// 文件评论积分变化并在持久化之后触发事件
        /// </summary>
        public static void AfterPointChangeOfFileComment(FileComment comment, ObjectState state, UserPointDirection userPointDirection)
        {
            try
            {
                FileEventManager.Instance().ExecutePointChangeOfFileCommentEvents(comment, state, userPointDirection);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("执行文件积分变化并在持久化之后触发事件时出现错误", e);
            }
        }
    }
}
