//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Data;
using System.Xml;

using System.IO;
using SpaceBuilder.Common;
using System.Security.Cryptography;
using System.Reflection;
using System.Web.Security;


namespace SpaceBuilder.File
{
    /// <summary>
    /// ļṩ߳
    /// </summary>
    public abstract class FileDataProvider
    {
        /// <summary>
        /// ļṩ߳
        /// </summary>
        public static readonly string FileDataProviderName = "FileDataProvider";

        #region Instance

        private static FileDataProvider _defaultInstance = null;

        static FileDataProvider()
        {
            CreateDefaultCommonProvider();
        }

        /// <summary>
        /// Returns an instance of the user-specified data provider class.
        /// </summary>
        /// <returns>An instance of the user-specified data provider class.  This class must inherit the
        /// CommonDataProvider interface.</returns>
        public static FileDataProvider Instance()
        {
            return _defaultInstance;
        }

        /// <summary>
        /// Creates the Default DataProvider
        /// </summary>
        private static void CreateDefaultCommonProvider()
        {
            SPBConfig config = SPBConfig.Instance();
            Provider sqlFileDateProvider = (Provider)config.Providers[FileDataProviderName];
            _defaultInstance = DataProviders.CreateInstance(sqlFileDateProvider) as FileDataProvider;
        }

        #endregion

        #region FileSection

        /// <summary>
        /// FileSection
        /// </summary>
        public abstract FileSection CreateUpdateSection(FileSection section, DataProviderAction action);

        /// <summary>
        /// ɾFileSection
        /// </summary>
        public abstract void DeleteSection(int ownerUserID);

        /// <summary>
        /// ݿռļģSectionIDȡռļģ
        /// </summary>
        public abstract FileSection GetSection(int ownerUserID);

        /// <summary>
        /// ȡʽļID
        /// </summary>
        /// <param name="sortBy">ʽ</param>
        /// <param name="maxRecords">¼</param>
        /// <param name="privacyStatusesForDisplay">ʾ˽״̬</param>
        /// <param name="auditingStatusesForDisplay">ʾ״̬</param>
        /// <returns></returns>
        public abstract BlockPagingID GetFileSectionIDsSortBy(FileSectionSortBy sortBy, int maxRecords, FileActiveStatus? fileActiveStatus, bool onlyShowHasContent);

        /// <summary>
        /// ȡûѵFileSectionID
        /// </summary>
        public abstract BlockPagingID GetFileSectionIDsOfFriends(int userID);

        /// <summary>
        /// FileSectionͳ
        /// </summary>
        public abstract void ExecFileSectionResetStatistics(List<int> list);

        #endregion

        #region FileThread

        /// <summary>
        /// ļ
        /// </summary>
        /// <param name="thread">Ҫļʵ</param>
        public abstract void CreateThread(FileThread thread);

        /// <summary>
        /// ļ
        /// </summary>
        /// <param name="thread">Ҫµļʵ</param>
        public abstract void UpdateThread(FileThread thread);

        /// <summary>
        /// վ
        /// </summary>
        public abstract void UpdateThreadsSiteCategory(List<int> threadIDs, int siteCategoryID);

        /// <summary>
        /// û
        /// </summary>
        public abstract void UpdateThreadsUserCategory(List<int> threadIDs, int userCategoryID);

        /// <summary>
        /// ɾļ
        /// </summary>
        /// <param name="postID">ҪɾļThreadID</param>
        public abstract void DeleteThread(int threadID);

        /// <summary>
        /// ɾļ
        /// </summary>
        public abstract void DeleteThreads(List<int> threadIDs);

        /// <summary>
        /// ״̬
        /// </summary>
        public abstract void UpdateThreadAuditingStatus(List<int> threadIDs, AuditingStatuses auditingStatus);

        /// <summary>
        /// ˽״̬
        /// </summary>
        /// <param name="threadIDs">Ҫ˽״̬IDs</param>
        /// <param name="privacyStatus">Ҫóɵ˽״̬</param>
        public abstract void UpdateThreadPrivacyStatus(List<int> threadIDs, PrivacyStatuses privacyStatus);


        /// <summary>
        /// ļPostIDȡļʵ
        /// </summary>
        /// <param name="threadID">ļthreadID</param>
        /// <param name="includeTags">ȡļǷǩ</param>
        /// <returns>ļʵ</returns>
        public abstract FileThread GetThread(int threadID);


        /// <summary>
        /// QueryȡļID
        /// </summary>
        /// <param name="ownerUserID"></param>
        /// <param name="tagName"></param>
        /// <param name="userCategoryID"></param>
        /// <param name="privacyStatusForDisplay"></param>
        /// <param name="auditingStatusForDisplay"></param>
        /// <param name="readFromWriteDB"></param>
        /// <param name="maxRecords"></param>
        /// <param name="pageSize"></param>
        /// <param name="pageIndex"></param>
        /// <returns>BlockPagingID</returns>
        public abstract BlockPagingID GetFileThreadIDs(int ownerUserID, string tagName, int? userCategoryID, PrivacyStatusesForDisplay? privacyStatusForDisplay, AuditingStatusesForDisplay? auditingStatusForDisplay, bool readFromWriteDB, int maxRecords, int pageSize, int pageIndex);

        /// <summary>
        /// ȡʽļID
        /// </summary>
        /// <param name="sortBy">ʽ</param>
        /// <param name="maxRecords">¼</param>
        /// <param name="privacyStatusesForDisplay">ʾ˽״̬</param>
        /// <param name="auditingStatusesForDisplay">ʾ״̬</param>
        /// <returns></returns>
        public abstract BlockPagingID GetFileThreadIDsSortBy(FileThreadSortBy sortBy, int? categoryID, string tagName, bool? isEssential, int maxRecords, PrivacyStatusesForDisplay? privacyStatusForDisplay, AuditingStatusesForDisplay? auditingStatusForDisplay);

        /// <summary>
        /// QueryȡļID(Ա̨ʹ)
        /// </summary>
        /// <param name="maxRecords"></param>
        /// <param name="pageSize"></param>
        /// <param name="pageIndex"></param>
        /// <param name="auditingStatusForDisplay"></param>
        /// <param name="ownerUserID"></param>
        /// <param name="subjectKeywords"></param>
        /// <returns></returns>
        public abstract BlockPagingID GetFileThreadIDsForAdmin(int maxRecords, int pageSize, int pageIndex, AuditingStatusesForDisplay? auditingStatusForDisplay, int? ownerUserID, string subjectKeywords);

        #endregion

        #region FileComment

        /// <summary>
        /// ļ
        /// </summary>
        /// <param name="comment">Ҫļ</param>
        public abstract void CreateComment(FileComment comment);

        /// <summary>
        /// ȡļ
        /// </summary>
        /// <param name="postID">۵ID</param>
        public abstract FileComment GetFileComment(int postID);

        /// <summary>
        /// ȡļµID
        /// </summary>
        /// <param name="maxRecords"></param>
        /// <param name="pageSize"></param>
        /// <param name="pageIndex"></param>
        /// <param name="threadID"></param>
        /// <returns></returns>
        public abstract BlockPagingID GetFileCommentIDsOfThread(AuditingStatusesForDisplay auditingStatusForDisplay, int maxRecords, int pageSize, int pageIndex, int threadID);



        /// <summary>
        /// QueryȡļID
        /// </summary>
        /// <param name="ownerUserID"></param>
        /// <param name="approvalStatus"></param>
        /// <param name="auditingStatusForDisplay"></param>
        /// <param name="readFromWriteDB"></param>
        /// <param name="maxRecords"></param>
        /// <param name="pageSize"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public abstract BlockPagingID GetFileCommentIDs(int ownerUserID, ApprovalStatuses? approvalStatus, AuditingStatusesForDisplay? auditingStatusForDisplay, bool readFromWriteDB, int maxRecords, int pageSize, int pageIndex);

        /// <summary>
        /// QueryȡļID(Ա̨ʹ)
        /// </summary>
        /// <param name="maxRecords"></param>
        /// <param name="pageSize"></param>
        /// <param name="pageIndex"></param>
        /// <param name="auditingStatusForDisplay"></param>
        /// <param name="userID"></param>
        /// <param name="bodyKeywords"></param>
        /// <returns></returns>
        public abstract BlockPagingID GetFileCommentIDsForAdmin(int maxRecords, int pageSize, int pageIndex, AuditingStatusesForDisplay? auditingStatusForDisplay, int? userID, string bodyKeywords);

        /// <summary>
        /// ļظ׼
        /// </summary>
        /// <param name="postID">ļظPostID</param>
        /// <param name="isApproved">Ƿ׼</param>
        public abstract void ApproveComments(List<int> postIDs, bool isApproved);

        /// <summary>
        /// ״̬
        /// </summary>
        public abstract void UpdateCommentAuditingStatus(List<int> postIDs, AuditingStatuses auditingStatus);

        /// <summary>
        /// ɾļ
        /// </summary>
        /// <param name="postID">ҪɾļӵID</param>
        public abstract void DeleteComment(int postID);


        #endregion

        #region FileDownLoadRecord

        /// <summary>
        /// ȡĳûؼ¼ֵ
        /// Key=ThreadID
        /// Value=FileDownLoadRecordID
        /// </summary>
        public abstract Dictionary<int, int> GetThreadIDDownLoadRecordIDsOfUser(int userID);

        /// <summary>
        /// ؼ¼
        /// </summary>
        public abstract void CreateDownLoadRecord(FileDownLoadRecord record);

        public abstract void DeleteDownloadRecordsByUserID(int userID);


        /// <summary>
        /// ȡؼ¼
        /// </summary>
        public abstract FileDownLoadRecord GetFileDownLoadRecord(int recordID);

        /// <summary>
        /// ȡĳûؼ¼ҳ
        /// </summary>
        public abstract BlockPagingID GetFileDownLoadRecords(int MaxRecords, int pageSize, int pageIndex, int userID);

        /// <summary>
        /// ȡļǰNؼ¼
        /// </summary>
        public abstract List<int> GetTopRecordIDsOfThread(int threadID, int topNumber);
        #endregion


        #region siteCategory

        /// <summary>
        /// վ
        /// </summary>
        public abstract void UpdateFileSiteCategories(int fromSiteCategoryID, int toSiteCategoryID);

        #endregion

        #region Rating

        /// <summary>
        /// 
        /// </summary>        
        /// <remarks>
        /// û۹۽
        /// </remarks>
        public abstract void Rate(Rating rating);

        /// <summary>
        /// ȡItemID
        /// </summary>
        public abstract List<Rating> GetRatings(int itemID, int topNumber);

        #endregion

        #region Top & Essential

        /// <summary>
        /// ö/ȡö
        /// </summary>
        public abstract void SetSticky(List<int> threadIDs, int specialOrder);

        /// <summary>
        /// þ/ȡ
        /// </summary>
        public abstract void SetEssential(List<int> threadIDs, bool isEssential);

        #endregion

        #region   delete User & Statistics

        /// <summary>
        ///  ɾûûʱļص
        /// </summary>
        /// <param name="userID">ҪɾûID</param>
        /// <param name="reassignUserName">ûUserName</param>
        public abstract void DeleteUserAndReassignContent(int userID, string reassignUserName);

        /// <summary>
        /// ļӦͳ
        /// </summary>
        public abstract void ExecuteStatistics();

        /// <summary>
        /// ȡļͳ
        /// </summary>
        public abstract Dictionary<FileManageableCounts, int> GetManageableCounts();
        #endregion

        #region FileSection

        /// <summary>
        /// FileSectionµݿ
        /// </summary>
        /// <param name="countObjects">FileSection</param>
        public abstract void SaveFileSectionCounterQueue(Dictionary<int, int> countObjects);

        #endregion

        #region ļ

        /// <summary>
        /// ļµݿ
        /// </summary>
        public abstract void SaveFileThreadCounterQueue(Dictionary<int, int> rssViewCounts, Dictionary<int, int> webViewCounts, Dictionary<int, int> downloadCountCounts);

        #endregion

        #region Populate

        /// <summary>
        /// IDataReaderװFileSection
        /// </summary>
        public static FileSection PopulateFileSectionFromIDataReader(IDataReader dr)
        {
            FileSection section = new FileSection();
            section.OwnerUserID = Convert.ToInt32(dr["OwnerUserID"]);
            section.SectionName = Convert.ToString(dr["SectionName"]);
            section.Description = Convert.ToString(dr["Description"]);
            section.IsActive = Convert.ToBoolean(dr["IsActive"]);
            section.EnableSearch = Convert.ToBoolean(dr["EnableSearch"]);
            section.DateCreated = Convert.ToDateTime(dr["DateCreated"]);
            section.DownloadFileCount = Convert.ToInt32(dr["DownloadFileCount"]);
            if (dr["MostRecentPostDate"] != DBNull.Value)
            {
                section.MostRecentPostDate = Convert.ToDateTime(dr["MostRecentPostDate"]);
            }
            if (dr["MostRecentThreadID"] != DBNull.Value)
            {
                section.MostRecentThreadID = Convert.ToInt32(dr["MostRecentThreadID"]);
            }
            if (dr["MostRecentThreadSubject"] != DBNull.Value)
            {
                section.MostRecentThreadSubject = Convert.ToString(dr["MostRecentThreadSubject"]);
            }
            if (dr["MostRecentThreadSummary"] != DBNull.Value)
            {
                section.MostRecentThreadSummary = Convert.ToString(dr["MostRecentThreadSummary"]);
            }
            section.FileCount = Convert.ToInt32(dr["FileCount"]);
            section.CommentCount = Convert.ToInt32(dr["CommentCount"]);
            section.Points = Convert.ToInt32(dr["Points"]);
            section.HitTimes = Convert.ToInt32(dr["HitTimes"]);
            section.StageHitTimes = Convert.ToInt32(dr["StageHitTimes"]);

            SerializerData data = CommonDataProvider.PopulateSerializerDataFromIDataReader(dr);
            section.SetSerializerData(data);

            return section;
        }

        /// <summary>
        /// IDataReaderװFileThread
        /// </summary>
        public static FileThread PopulateFileThreadFromIDataReader(IDataReader dr)
        {
            FileThread thread = new FileThread();
            thread.ThreadID = Convert.ToInt32(dr["ThreadID"]);
            thread.OwnerUserID = Convert.ToInt32(dr["OwnerUserID"]);
            thread.Author = Convert.ToString(dr["Author"]);
            thread.PostDate = Convert.ToDateTime(dr["PostDate"]);
            thread.LastRepliedDate = Convert.ToDateTime(dr["LastRepliedDate"]);
            thread.PrivacyStatus = (PrivacyStatuses)Convert.ToInt32(dr["PrivacyStatus"]);
            thread.Password = Convert.ToString(dr["Password"]);
            thread.IsLocked = Convert.ToBoolean(dr["IsLocked"]);
            thread.IsEssential = Convert.ToBoolean(dr["IsEssential"]);
            thread.SpecialOrder = Convert.ToInt32(dr["SpecialOrder"]);
            thread.StickyDate = Convert.ToDateTime(dr["StickyDate"]);
            thread.HitTimes = Convert.ToInt32(dr["HitTimes"]);
            thread.RssViewTimes = Convert.ToInt32(dr["RssViewTimes"]);
            thread.CommentCount = Convert.ToInt32(dr["CommentCount"]);
            thread.DownloadCount = Convert.ToInt32(dr["DownloadCount"]);
            thread.RatingSum = Convert.ToInt32(dr["RatingSum"]);
            thread.TotalRatings = Convert.ToInt32(dr["TotalRatings"]);
            thread.Subject = Convert.ToString(dr["Subject"]);
            //thread.Body = Convert.ToString(dr["Body"]);
            thread.SiteCategoryID = Convert.ToInt32(dr["SiteCategoryID"]);
            thread.UserCategoryID = Convert.ToInt32(dr["UserCategoryID"]);
            thread.AuditingStatus = (AuditingStatuses)Convert.ToInt32(dr["AuditingStatus"]);
            thread.UserHostAddress = Convert.ToString(dr["UserHostAddress"]);

            Attachment attachment = new Attachment(FileAttachmentManager.Instance().StorageProviderName, Convert.ToString(dr["FileName"]));
            thread.Attachment = attachment;
            //thread.Attachment.FileName = Convert.ToString(dr["FileName"]);
            thread.Attachment.ContentType = Convert.ToString(dr["ContentType"]);
            thread.Attachment.ContentSize = Convert.ToInt32(dr["ContentSize"]);
            thread.Attachment.Height = Convert.ToInt32(dr["Height"]);
            thread.Attachment.Width = Convert.ToInt32(dr["Width"]);
            thread.Attachment.IsRemote = Convert.ToBoolean(dr["IsRemote"]);
            thread.Attachment.DateCreated = Convert.ToDateTime(dr["PostDate"]);

            thread.PrevThreadID = Convert.ToInt32(dr["PrevThreadID"]);
            thread.PrevThreadSubject = Convert.ToString(dr["PrevThreadSubject"]);
            thread.NextThreadID = Convert.ToInt32(dr["NextThreadID"]);
            thread.NextThreadSubject = Convert.ToString(dr["NextThreadSubject"]);

            thread.Price = Convert.ToInt32(dr["Price"]);
            thread.StageHitTimes = Convert.ToInt32(dr["StageHitTimes"]);
            thread.StageDownloadCount = Convert.ToInt32(dr["StageDownloadCount"]);


            thread.FileName = attachment.FileName;
            thread.ContentSize = attachment.ContentSize;
            thread.ContentType = attachment.ContentType;
            thread.Height = attachment.Height;
            thread.Width = attachment.Width;
            thread.IsRemote = attachment.IsRemote;

            thread.SetSerializerData(CommonDataProvider.PopulateSerializerDataFromIDataReader(dr));

            return thread;
        }

        /// <summary>
        /// ȡFileThread
        /// </summary>
        public abstract string GetFileThreadBody(int threadID);


        /// <summary>
        /// IDataReaderװFileComment
        /// </summary>
        public static FileComment PopulateFileCommentFromIDataReader(IDataReader dr)
        {
            FileComment post = new FileComment();
            post.PostID = Convert.ToInt32(dr["PostID"]);
            post.ParentID = Convert.ToInt32(dr["ParentID"]);
            post.ThreadID = Convert.ToInt32(dr["ThreadID"]);
            post.OwnerUserID = Convert.ToInt32(dr["OwnerUserID"]);
            post.UserID = Convert.ToInt32(dr["UserID"]);
            post.Author = Convert.ToString(dr["Author"]);
            post.Body = Convert.ToString(dr["Body"]);
            post.IsApproved = Convert.ToBoolean(dr["IsApproved"]);
            post.AuditingStatus = (AuditingStatuses)Convert.ToInt32(dr["AuditingStatus"]);
            post.UserHostAddress = Convert.ToString(dr["UserHostAddress"]);
            post.PostDate = Convert.ToDateTime(dr["PostDate"]);

            post.SetSerializerData(CommonDataProvider.PopulateSerializerDataFromIDataReader(dr));

            return post;
        }

        public static Rating PopulateFileRatingFromIDataReader(IDataReader dr)
        {
            Rating rating = new Rating();
            rating.ItemID = Convert.ToInt32(dr["ThreadID"]);
            rating.UserID = Convert.ToInt32(dr["UserID"]);
            rating.Author = Convert.ToString(dr["Author"]);
            rating.Rate = Convert.ToInt32(dr["Rate"]);

            return rating;
        }

        //public static void PopulateUserDownloadFromIDataReader(IDataReader dr, ref UserDownload ud)
        //{
        //    ud.User = CommonDataProvider.cs_PopulateUserFromIDataReader(dr);
        //    ud.LatestDownloadDate = (DateTime)dr["LatestDownloadDate"];
        //    ud.TotalDownloads = (int)dr["TotalDownloads"];
        //    ud.PostID = (int)dr["PostID"];
        //}

        public static FileDownLoadRecord PopulateFileDownLoadRecordFromDataReader(IDataReader dr)
        {
            FileDownLoadRecord downLodRecord = new FileDownLoadRecord();
            downLodRecord.RecordID = Convert.ToInt32(dr["RecordID"]);
            downLodRecord.UserID = Convert.ToInt32(dr["UserID"]);
            downLodRecord.ThreadID = Convert.ToInt32(dr["ThreadID"]);
            downLodRecord.UserDisplayName = Convert.ToString(dr["UserDisplayName"]);
            downLodRecord.Price = Convert.ToInt32(dr["Price"]);
            downLodRecord.DateCreated = Convert.ToDateTime(dr["DateCreated"]);
            downLodRecord.UserHostAddress = Convert.ToString(dr["UserHostAddress"]);
            return downLodRecord;

        }
        #endregion

        #region User Password Helper

        /// <summary>
        /// Ƿȷ
        /// </summary>
        internal virtual bool CheckPassword(string password, string storedPassword, UserPasswordFormats passwordFormat, string passwordSalt)
        {
            string encodedPassword = EncodePassword(password, passwordFormat, passwordSalt);

            if (encodedPassword != null)
                return encodedPassword.Equals(storedPassword, StringComparison.CurrentCultureIgnoreCase);
            else
                return false;
        }

        /// <summary>
        /// б
        /// </summary>
        protected virtual string EncodePassword(string password, UserPasswordFormats passwordFormat, string passwordSalt)
        {
            if (passwordFormat == UserPasswordFormats.Clear)
                return password;

            byte[] bIn = Encoding.Unicode.GetBytes(password);
            byte[] bSalt = Convert.FromBase64String(passwordSalt);
            byte[] bAll = new byte[bSalt.Length + bIn.Length];

            Buffer.BlockCopy(bSalt, 0, bAll, 0, bSalt.Length);
            Buffer.BlockCopy(bIn, 0, bAll, bSalt.Length, bIn.Length);

            switch (passwordFormat)
            {
                case UserPasswordFormats.HashedFromMembership:
                    byte[] bRet = null;
                    HashAlgorithm algorithm = HashAlgorithm.Create(Membership.HashAlgorithmType);
                    bRet = algorithm.ComputeHash(bAll);
                    return Convert.ToBase64String(bRet);

                case UserPasswordFormats.EncryptedFromMembership:
                    string encodededPassword;
                    MembershipProvider membershipProvider = Membership.Provider;
                    Type baseProviderType = typeof(MembershipProvider);

                    //EncodePassword is an internally scoped method. So we will try to invoke it via reflection
                    MethodInfo mi = baseProviderType.GetMethod("EncodePassword", BindingFlags.Public | BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.FlattenHierarchy);

                    if (mi != null)
                        encodededPassword = mi.Invoke(membershipProvider, new object[] { password, MembershipPasswordFormat.Encrypted, passwordSalt }) as string;
                    else
                        encodededPassword = null;

                    return encodededPassword;

                case UserPasswordFormats.EncryptedFromSpaceBuilder:
                    return EncryptManager.EncryptTokenForPassword(password);

                case UserPasswordFormats.MD5:
                    return EncryptManager.MD5(password);

                default:
                    return null;
            }
        }

        /// <summary>
        /// Salt
        /// </summary>
        internal virtual string GenerateSalt()
        {
            int size = 24;

            byte[] buffer = new byte[size];
            (new RNGCryptoServiceProvider()).GetBytes(buffer);
            return Convert.ToBase64String(buffer);
        }

        #endregion


    }
}
