﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


using System.Data;
using SpaceBuilder.Common;

namespace SpaceBuilder.File
{
    /// <summary>
    /// 资讯附件数据提供抽象类
    /// </summary>
    public abstract class FileFeaturedImageDataProvider : AttachmentDataProvider
    {
        public static readonly string FileFeaturedImageDataProviderName = "FileFeaturedImageDataProvider";

        #region Instance

        public static volatile FileFeaturedImageDataProvider _defaultInstance = null;

        static FileFeaturedImageDataProvider()
        {
            CreateDefaultDataProvider();
        }

        public static FileFeaturedImageDataProvider Instance()
        {
            return _defaultInstance;
        }

        private static void CreateDefaultDataProvider()
        {
            SPBConfig config = SPBConfig.Instance();
            Provider sqlProvider = config.Providers[FileFeaturedImageDataProviderName];
            _defaultInstance = DataProviders.CreateInstance(sqlProvider) as FileFeaturedImageDataProvider;
        }

        #endregion

        #region PopulateFromIDataReader

        public static Attachment PopulateFileAttachmentFromIDataReader(IDataReader dr)
        {
            Attachment attachment = new Attachment(FileFeaturedImageManager.Instance().StorageProviderName, Convert.ToString(dr["FileName"]));

            attachment.AttachmentID = Convert.ToInt32(dr["AttachmentID"]);
            attachment.AssociateID = Convert.ToInt32(dr["ThreadID"]);
            attachment.UserID = Convert.ToInt32(dr["UserID"]);
            //attachment.FileName = Convert.ToString(dr["FileName"]);
            attachment.FriendlyFileName = Convert.ToString(dr["FriendlyFileName"]);
            attachment.ContentType = Convert.ToString(dr["ContentType"]);
            attachment.ContentSize = Convert.ToInt32(dr["ContentSize"]);
            attachment.Height = Convert.ToInt32(dr["Height"]);
            attachment.Width = Convert.ToInt32(dr["Width"]);
            attachment.IsRemote = Convert.ToBoolean(dr["IsRemote"]);
            attachment.DateCreated = Convert.ToDateTime(dr["DateCreated"]);
            attachment.DownloadCount = 0;

            return attachment;
        }

        #endregion
    }
}