﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;

using SpaceBuilder.Common.Controllers;
using SpaceBuilder.Forum;
using SpaceBuilder.Common;

using SpaceBuilder.Web;
using System.Collections.Specialized;


namespace SpaceBuilder.Forum.Controllers
{
    /// <summary>
    /// 个人空间的论坛显示控制器
    /// </summary>
    [UserDomainGuideInstallApplication(ApplicationID = 211)]
    [HttpCompress]
    public class UserDomainForumController : UserDomainControllerBase
    {
        /// <summary>
        /// 个人空间的论坛显示
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ListMyForums(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            if (currentDomainUser == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserRoomNotExist", ApplicationIDs.Instance().Forum()), userDomainName)));
            }
            SetPageTitle(userDomainName, GetResourceString("Title_MyForums", ApplicationIDs.Instance().Forum()));
            return View("Pages/Forum/ListMyForums.aspx", "Masters/Forum.master");
        }
        /// <summary>
        /// 我朋友的帖子
        /// </summary>
        [UserDomainPrivacy(IsAuthentication = true)]
        public ActionResult ListMyFriendForums(string userDomainName)
        {
            SetPageTitle(userDomainName, GetResourceString("Title_MyFriendsForums", ApplicationIDs.Instance().Forum()));
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            if (currentDomainUser == null)
            {
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserRoomNotExist", ApplicationIDs.Instance().Forum()), userDomainName)));
            }
            return View("Pages/Forum/ListFriendForums.aspx", "Masters/Forum.master");
        }
        ///<summary>
        ///显示我的论坛详细列表
        ///</summary>
        public ActionResult Control_ListMyForums(string userDomainName, int? presentAreaID, int? pageIndex)
        {

            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            if (currentDomainUser == null)
                return Redirect(SiteUrls.Instance().Error404(string.Format(GetResourceString("Exception_Pattern_UserRoomNotExist", ApplicationIDs.Instance().Forum()), userDomainName)));

            PagingDataSet<ForumThread> pds = null;

            if (HasManagePermission(userDomainName))
                pds = ForumThreads.GetMyThreads(currentDomainUser.UserID, presentAreaID, pageIndex ?? 1);
            else
                pds = ForumThreads.GetUserThreads(currentDomainUser.UserID, presentAreaID, pageIndex ?? 1);

            if (IsUserDomainOwner(userDomainName))
                ViewData["IsUserDomainOwner"] = true;
            ForumThread dd = new ForumThread();

            return PartialView("Controls/Forum/ListMyForums.ascx", pds);
        }
        /// <summary>
        /// 回复
        /// </summary>       
        public ActionResult Control_ListPostForums(string userDomainName, int? presentAreaID, int? pageIndex, bool isFriends)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            PagingDataSet<ForumPost> forumPost = null;
            if (!isFriends)
            {
                forumPost = ForumPosts.GetMyPosts(currentDomainUser.UserID, presentAreaID, pageIndex ?? 1);
            }
            else
            {
                forumPost = ForumPosts.GetMyFriendPosts(currentDomainUser.UserID, presentAreaID, pageIndex ?? 1);
            }
            Dictionary<int, ForumThread> forumThreads = new Dictionary<int, ForumThread>();
            foreach (ForumPost post in forumPost.Records)
            {
                forumThreads[post.ThreadID] = ForumThreads.GetThread(post.ThreadID, false);
            }
            ViewData["forumThreads"] = forumThreads;
            ViewData["isFriends"] = isFriends;
            return PartialView("Controls/Forum/ListPostForums.ascx", forumPost);
        }


        /// <summary>
        /// 显示我朋友的帖子列表
        /// </summary>      
        public ActionResult Control_ListMyFriendForums(string userDomainName, int? presentAreaID, int? pageIndex)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            PagingDataSet<ForumThread> pds = ForumThreads.GetMyFriendThreads(currentDomainUser.UserID, presentAreaID, pageIndex ?? 1);
            return PartialView("Controls/Forum/ListMyFriendForums.ascx", pds);
        }

        /// <summary>
        /// 统计信息
        /// </summary>      
        public ActionResult Control_ForumCountBlock(string userDomainName)
        {
            User currentDomainUser = GetCurrentDomainUser(userDomainName);
            ForumUserData forumUserData = ForumUserDatas.GetUserData(currentDomainUser.UserID, false);
            return PartialView("Controls/Forum/ForumCountBlock.ascx", forumUserData);
        }
    }
    /// <summary>
    /// 空间论坛二级菜单
    /// </summary>
    public enum ForumUserDomainSubMenus
    {
        /// <summary>
        /// 我的论坛
        /// </summary>
        myForum = 1,

        /// <summary>
        /// 朋友的论坛
        /// </summary>
        friendForum = 10,

        /// <summary>
        /// 站点中的论坛
        /// </summary>
        siteForum = 20
    }
}
