﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using System.Text.RegularExpressions;
using SpaceBuilder.Caching;
using SpaceBuilder.Utils;
using System.Security.Policy;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Forum
{
    public static class ForumPostExtensions
    {
        /// <summary>
        /// 获取body
        /// </summary>
        public static string GetBody(this ForumPost post, bool hasEditPermission)
        {
            //转换帖子内容中的UBB引用编码
            string body = post.Body;
            body = BBCodeTransforms.BBQuoteCodeToHtml(body);
            //if (!post.HasAttachment)
            //    return post.Body;

            User currentUser = Globals.GetCurrentUser();
            if (post.HasTradeAttachment)
            {
                if (hasEditPermission && !string.IsNullOrEmpty(post.FullParsedBody))
                    body = post.FullParsedBody;
                else if (currentUser == null && !string.IsNullOrEmpty(post.ZeroParsedBody))
                    body = post.ZeroParsedBody;
                else
                    body = ParseAttachments(post, body, currentUser, hasEditPermission);
            }
            else if (!post.HasParsedNoTradeBody)
            {
                body = ParseAttachments(post, body, currentUser, hasEditPermission);
            }

            return body;
        }
        /// <summary>
        /// 转换帖子附件
        /// </summary>
        private static string ParseAttachments(ForumPost post, string body, User currentUser, bool hasEditPermission)
        {

            List<Attachment> attachmentsOfPost = ForumAttachmentManager.Instance().GetAttachmentsByAssociateID(post.PostID, false);
            int hasPayOutCount = 0;//已经付过钱的附件数
            int totalNeedPayCount = 0;//需要付钱的附件总数
            if (attachmentsOfPost != null && attachmentsOfPost.Count > 0)
            {
                string attachmentReplacement = string.Empty;
                SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
                foreach (Attachment attachment in attachmentsOfPost)
                {
                    if (attachment.IsImage)
                    {
                        if (siteSettings.InlinedImageWidth > 0 && attachment.Width > siteSettings.InlinedImageWidth)
                            attachmentReplacement = string.Format("<a href=\"{0}\" target=\"_blank\"><img src=\"{0}\" alt=\"{1}\" border=\"0\" width=\"{2}\" /></a>", SiteUrls.Instance().DownloadForumAttachment(attachment.AttachmentID), attachment.FriendlyFileName, siteSettings.InlinedImageWidth);
                        else if (siteSettings.InlinedImageHeight > 0 && attachment.Height > siteSettings.InlinedImageHeight)
                            attachmentReplacement = string.Format("<a href=\"{0}\" target=\"_blank\"><img src=\"{0}\" alt=\"{1}\" border=\"0\" height=\"{2}\" /></a>", SiteUrls.Instance().DownloadForumAttachment(attachment.AttachmentID), attachment.FriendlyFileName, siteSettings.InlinedImageHeight);
                        else
                            attachmentReplacement = string.Format("<a href=\"{0}\" target=\"_blank\"><img src=\"{0}\" alt=\"{1}\" border=\"0\" /></a>", SiteUrls.Instance().DownloadForumAttachment(attachment.AttachmentID), attachment.FriendlyFileName);

                        body = Regex.Replace(body, string.Format(@"\[attachimg\]{0}\[/attachimg\]", attachment.AttachmentID), attachmentReplacement, RegexOptions.IgnoreCase);
                    }
                    else
                    {
                        if (attachment.Price > 0)
                        {
                            if (currentUser == null)
                            {
                                attachmentReplacement = string.Format("<div class=\"annexInlaid\">{0}<em>（{1}）</em><em>已下载：{2}次</em><em>需积分：{3}</em>(需要登陆后才能下载)</div> ", attachment.FriendlyFileName, attachment.Friendlylength, attachment.DownloadCount, attachment.Price);
                            }
                            else if (ForumAttachmentManager.Instance().IsPayOut(attachment.AttachmentID, currentUser.UserID) || hasEditPermission)
                            {
                                attachmentReplacement = string.Format("<div class=\"annexInlaid\"><a href=\"{0}\" taget=\"_blank\">{1}</a><em>（{2}）</em><em>已下载：{3}次</em></div>", SiteUrls.Instance().DownloadForumAttachment(attachment.AttachmentID), attachment.FriendlyFileName, attachment.Friendlylength, attachment.DownloadCount);
                                hasPayOutCount++;
                            }
                            else
                                attachmentReplacement = string.Format("<div class=\"annexInlaid\"><a href=\"{4}\" onclick=\"if(!confirm('{5}')) return false;\" target=\"_self\">{0}</a><em>（{1}）</em><em>已下载：{2}次</em><em>需积分：{3}</em>(请先购买)</div>", attachment.FriendlyFileName, attachment.Friendlylength, attachment.DownloadCount, attachment.Price, SPBUrlHelper.Action("ExchangeAttachmentAction", "ChannelForum", new RouteValueDictionary { { "attachmentID", attachment.AttachmentID } }), string.Format("购买之后将从你的金币中扣除：{0}，你确定要购买吗？", attachment.Price));
                            totalNeedPayCount++;
                        }

                        if ((attachment as ForumAttachment) != null)
                        {
                            ForumAttachment forumAttachment = attachment as ForumAttachment;
                            if (currentUser == null && forumAttachment.IsHidden)
                                attachmentReplacement = string.Format("<div class=\"annexInlaid\">{0}<em>（{1}）</em><em>已下载：{2}次</em>(匿名用户需要登陆后回复才可下载)</div> ", attachment.FriendlyFileName, attachment.Friendlylength, attachment.DownloadCount);
                            else if (forumAttachment.IsHidden && !ForumPosts.IsReplyer(post.ThreadID, currentUser.UserID))
                                attachmentReplacement = string.Format("<div class=\"annexInlaid\">{0}<em>（{1}）</em><em>已下载：{2}次</em>(需要回复才可下载)</div>", attachment.FriendlyFileName, attachment.Friendlylength, attachment.DownloadCount);
                            else if (attachment.Price <= 0)
                                attachmentReplacement = string.Format("<div class=\"annexInlaid\"><a href=\"{0}\" taget=\"_blank\">{1}</a><em>（{2}）</em><em>已下载：{3}次</em></div>", SiteUrls.Instance().DownloadForumAttachment(attachment.AttachmentID), attachment.FriendlyFileName, attachment.Friendlylength, attachment.DownloadCount);
                        }

                        if (attachment.Price <= 0 && (attachment as ForumAttachment) == null)
                            attachmentReplacement = string.Format("<div class=\"annexInlaid\"><a href=\"{0}\" taget=\"_blank\">{1}</a><em>（{2}）</em><em>已下载：{3}次</em></div>", SiteUrls.Instance().DownloadForumAttachment(attachment.AttachmentID), attachment.FriendlyFileName, attachment.Friendlylength, attachment.DownloadCount);

                        body = Regex.Replace(body, string.Format(@"\[attach\]{0}\[/attach\]", attachment.AttachmentID), attachmentReplacement);
                    }
                }
            }
            //清除无效的[attach][attachimg]
            body = Regex.Replace(body, @"\[attachimg\](\d+)\[/attachimg\]", string.Empty);
            body = Regex.Replace(body, @"\[attach\](\d+)\[/attach\]", string.Empty);
            if (string.IsNullOrEmpty(post.ZeroParsedBody) && string.IsNullOrEmpty(post.FullParsedBody))
            {
                if (hasPayOutCount == 0)
                    post.ZeroParsedBody = body;

                if (hasPayOutCount == totalNeedPayCount)
                    post.FullParsedBody = body;
                if (totalNeedPayCount == 0)
                    post.HasTradeAttachment = false;
            }
            return body;
        }

        /// <summary>
        /// 截取非引用部分的文字
        /// </summary>
        /// <param name="charLimt">需截取非引用部分的文字字数限制</param>
        /// <returns>截取完的文字</returns>
        public static string TrimNoQuoteHtml(this ForumPost post,int charLimt)
        {
            string body = post.Body;          
            //先清除p标签
            body = Regex.Replace(body, @"\<p(?:\s*)\>((.|\n)*?)\</p(?:\s*)\>", "$1", RegexOptions.IgnoreCase);
            int endIndex = body.LastIndexOf("[/quote]");
            if (endIndex > 0)
            {

                return body.Substring(0, endIndex + 8)
                + HtmlUtils.TrimHtml(body.Substring(endIndex + 8), charLimt);
            }
            return HtmlUtils.TrimHtml(body, charLimt);
        }
    }
}