﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;

namespace SpaceBuilder.Forum
{
    /// <summary>
    /// 论坛中使用Cookie
    /// </summary>
    public static class ForumUserCookie
    {
        private static readonly string ForumSectionListModeCookieKey = "ForumSectionListMode:";

        /// <summary>
        /// 保存论坛版块列表的显示方式
        /// </summary>
        public static void SaveForumSectionsListMode(this UserCookie userCookieObject, int summary, int groupID)
        {

            if (userCookieObject.Cookie != null)
            {
                userCookieObject.Cookie[ForumSectionListModeCookieKey + groupID] = summary.ToString();
                userCookieObject.WriteCookie();
            }
        }

        /// <summary>
        /// 读取论坛版块列表的显示方式
        /// </summary>
        public static int GetForumSectionListMode(this UserCookie userCookieObject, int groupID)
        {
            int summary = (int)Forum.Controllers.BrowseMode.detail;

            if (userCookieObject.Cookie != null)
            {
                string summaryString = userCookieObject.Cookie[ForumSectionListModeCookieKey + groupID];
                if (!string.IsNullOrEmpty(summaryString))
                {
                    try
                    {
                        summary = int.Parse(summaryString);
                    }
                    catch
                    { }
                }
            }

            return summary;
        }
    }
}
