﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;
using System.Web;

using SpaceBuilder.Forum;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

using System.Web.Mvc;
using SpaceBuilder.Forum.Controllers;
using SpaceBuilder.Common;

namespace SpaceBuilder.Forum.Handlers
{
    /// <summary>
    /// 处理特殊的ForumUrl
    /// </summary>
    public class ForumUrlHandler : IHttpHandler
    {
        public bool IsReusable
        {
            get { return true; }
        }

        public void ProcessRequest(HttpContext context)
        {
            string url = string.Empty;
            int anchorPostID = 0;
            if (string.IsNullOrEmpty(context.Request.QueryString["anchorPostID"]) == false)
            {
                int.TryParse(context.Request.QueryString["anchorPostID"], out anchorPostID);
            }

            string clubDomainName = string.Empty;
            if (string.IsNullOrEmpty(context.Request.QueryString["ClubDomainName"]) == false)
            {
                clubDomainName = context.Request.QueryString["ClubDomainName"];
            }

            int threadID = 0;
            if (string.IsNullOrEmpty(context.Request.QueryString["ThreadID"]) == false)
            {
                int.TryParse(context.Request.QueryString["ThreadID"], out threadID);
            }

            ForumThread thread = ForumThreads.GetThread(threadID, false);
            if (thread != null)
            {
                int pageIndex = ForumPosts.GetPostsOfThreadPageIndex(threadID, anchorPostID);


                ForumSectionGroup group = ForumSectionGroups.GetGroup(thread.GroupID, false);
                if (group != null && group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                    clubDomainName = Club.ClubID2ClubNameDictionary.GetClubDomainName(group.OwnerID);

                if (string.IsNullOrEmpty(clubDomainName))
                {
                    if (anchorPostID > 0)
                    {
                        url = SiteUrls.Instance().ShowForumThreadPaged(threadID, pageIndex, anchorPostID);
                    }
                    else
                    {
                        url = SiteUrls.Instance().ShowForumThreadPaged(threadID, pageIndex);
                    }
                }
                else
                {
                    if (anchorPostID > 0)
                        url = SiteUrls.Instance().ShowForumThreadPagedAndPermLinkInClub(clubDomainName, thread.ThreadID, pageIndex, anchorPostID);
                    else
                        url = SiteUrls.Instance().ShowForumThreadPagedInClub(clubDomainName, thread.ThreadID, pageIndex);
                }
            }

            WebUtils.Redirect301(context, url);
        }
    }
}
