﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web.Mvc;


namespace SpaceBuilder.Forum.Handlers
{
    class ForumAttachmentsUploadHandler : IHttpHandler
    {
        #region IHttpHandler 成员

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            int currentUserID = int.Parse(EncryptManager.DecryptTokenForInviteFriend(context.Request.Form["currentUserID"]));
            int currentPostID = Convert.ToInt32(context.Request["associateID"]);
            int currentSectionID = Convert.ToInt32(context.Request["ownerID"]);
            bool isHidden = false;
            Boolean.TryParse(context.Request["isHidden"], out isHidden);
            int price = 0;
            int.TryParse(context.Request["price"], out price);

            //判断用户是否有上传图片的权限
            if (currentUserID < 1)
            {
                WebUtils.Return404(context);
                return;
            }

            User currentUser = Users.GetUser(currentUserID, false);
            if (currentUser == null)
            {
                WebUtils.Return404(context);
                return;
            }

            ForumPost currentPost = null;
            if (currentPostID > 0)
            {
                currentPost = ForumPosts.GetPost(currentPostID, false);
                if (currentPost == null)
                {
                    WebUtils.Return404(context);
                    return;
                }
            }

            bool isPermitted = true;
            System.Web.HttpPostedFile postedFile = context.Request.Files["Filedata"];

            if (postedFile.ContentLength > ForumConfiguration.Instance().AttachmentSettings.MaxAttachmentSize * 1024)
            {
                WebUtils.Return404(context);
                return;
            }
            if (!currentUser.IsContentAdministrator && context.Request.Files["Filedata"].ContentLength / 1024 > (currentUser.DatabaseQuota - currentUser.DatabaseQuotaUsed))
            {
                context.Response.StatusCode = 200;
                context.Response.Write("{message:'空间容量不足'}");
                context.Response.End();
            }

            if (!string.IsNullOrEmpty(postedFile.FileName))
            {
                string fileTypeString = postedFile.FileName.Substring(postedFile.FileName.LastIndexOf(".") + 1);
                string uploadPhotoTypes = ForumConfiguration.Instance().AttachmentSettings.Extensions;
                string[] types = uploadPhotoTypes.ToLower().Split(new char[] { ',', '，' }, StringSplitOptions.RemoveEmptyEntries);
                isPermitted = types.Contains(fileTypeString.ToLower());
            }
            if (isPermitted)
            {
                ForumAttachment attachment = new ForumAttachment(ForumAttachmentManager.Instance().StorageProviderName, null);
                attachment.UserID = currentUser.UserID;
                attachment.ContentSize = postedFile.ContentLength;
                attachment.ContentType = MimeTypeConfiguration.GetMimeType(postedFile.FileName);
                attachment.DateCreated = DateTime.Now;
                attachment.FriendlyFileName = postedFile.FileName;
                attachment.IsHidden = isHidden;
                attachment.Price = price;
                if (currentPostID > 0)
                {
                    attachment.OwnerID = currentPost.SectionID;
                    attachment.AssociateID = currentPostID;
                    ForumAttachmentManager.Instance().CreateAttachment(attachment, postedFile.InputStream);
                }
                else
                {
                    attachment.OwnerID = currentSectionID;
                    ForumAttachmentManager.Instance().CreateTemporaryAttachment(attachment, postedFile.InputStream);
                }
            }
            context.Response.StatusCode = 200;
            context.Response.Write("{ok:true}");
            context.Response.End();
        }

        #endregion
    }
}
