﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;
using SpaceBuilder.Club;
using SpaceBuilder.Forum;

namespace SpaceBuilder.Forum.Modules
{
    /// <summary>
    /// 处理与论坛相关的动态
    /// </summary>
    public class DisposeActivityForForum : IForumModule
    {

        #region IForumModule 成员

        public void Init(ForumEventManager eventManager, System.Xml.Linq.XElement node)
        {
            eventManager.AfterForumThreadChange += new ForumThreadEventHandler(eventManager_AfterForumThreadChange);
            eventManager.AfterForumPostChange += new ForumPostEventHandler(eventManager_AfterForumPostChange);
        }

        void eventManager_AfterForumPostChange(ForumPost forumPost, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().Forum()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(forumPost.UserID, false);
                if (user == null)
                    return;

                string itemKey = ActivityItemKeys.Instance().NewForumPost();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);

                ForumThread forumThread = ForumThreads.GetThread(forumPost.ThreadID, false);

                ForumSectionGroup group = ForumSectionGroups.GetGroup(forumThread.GroupID, true);
                if (group == null)
                    return;

                //论坛主题是否对所有人可见
                bool forumThreadIsPublic = GetIsPublic(forumThread);

                #region 处理个人动态

                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;

                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewForumPost", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user, true), GetForumPostSubjectWithHyperlink(forumThread, forumPost));
                userActivity.Body = HtmlUtils.TrimHtml(forumPost.Body, 250);

                if (forumPost.AuditingStatus == AuditingStatuses.Success && forumThreadIsPublic)
                    userActivity.IsPublic = true;
                else
                    userActivity.IsPublic = false;

                userActivity.RelativeItemID = forumPost.PostID;
                userActivity.RelativeItemName = forumPost.Subject;

                Activities.CreateUserActivity(userActivity);

                #endregion

                #region 处理朋友动态
                if (forumThreadIsPublic)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目
                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        userActivity.ApplicationID = activityItem.ApplicationID;
                        userActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;

                        friendActivity.Subject = userActivity.Subject;
                        friendActivity.Body = HtmlUtils.TrimHtml(forumPost.Body, 250);

                        friendActivity.RelativeItemID = forumPost.PostID;
                        friendActivity.RelativeItemName = forumPost.Subject;
                        friendActivity.ApplicationID = activityItem.ApplicationID;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }

        void eventManager_AfterForumThreadChange(ForumThread forumThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().Forum()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(forumThread.UserID, false);
                if (user == null)
                    return;

                string itemKey = ActivityItemKeys.Instance().NewForumThread();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);

                //论坛主题是否对所有人可见
                bool forumThreadIsPublic = GetIsPublic(forumThread);

                #region 处理个人动态

                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewForumThread", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user, true), GetForumPostSubjectWithHyperlink(forumThread, null));
                userActivity.Body = HtmlUtils.TrimHtml(forumThread.Body, 250);

                if (forumThreadIsPublic)
                    userActivity.IsPublic = true;
                else
                    userActivity.IsPublic = false;

                userActivity.RelativeItemID = forumThread.ThreadID;
                userActivity.RelativeItemName = forumThread.Subject;

                Activities.CreateUserActivity(userActivity);

                #endregion

                #region 处理朋友动态
                if (Auditings.IsInAllowScope(forumThread.AuditingStatus, ApplicationIDs.Instance().Forum()))
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //判断用户是否允许发送给 朋友动态项目
                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        userActivity.ApplicationID = activityItem.ApplicationID;
                        userActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;

                        friendActivity.Subject = userActivity.Subject;
                        friendActivity.Body = HtmlUtils.TrimHtml(forumThread.Body, 250);

                        friendActivity.RelativeItemID = forumThread.ThreadID;
                        friendActivity.RelativeItemName = forumThread.Subject;
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion

                #region 处理群组动态


                if (forumThread.GroupID <= 0)
                    return;

                ForumSectionGroup group = ForumSectionGroups.GetGroup(forumThread.GroupID, false);

                if (group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                {
                    ClubActivity clubActivity = new ClubActivity();
                    clubActivity.ApplicationID = ApplicationIDs.Instance().Forum();
                    clubActivity.ClubID = group.OwnerID;
                    clubActivity.LeadingActorUserID = user.UserID;
                    clubActivity.LeadingActor = user.DisplayName;
                    clubActivity.Subject = string.Format(" 发布了论坛主题 {0}", GetForumPostSubjectWithHyperlink(forumThread, null));
                    clubActivity.Body = userActivity.Body;
                    clubActivity.RelativeItemID = forumThread.ThreadID;
                    clubActivity.RelativeItemName = forumThread.Subject;
                    ClubActivities.CreateClubActivity(clubActivity);
                    if (clubActivity.ActivityID > 0)
                    {
                        PagingDataSet<ClubMember> members = ClubMembers.GetMembers(clubActivity.ClubID, null, null, ValueHelper.GetSqlMaxInt(), 1, false);
                        List<int> memberIDs = new List<int>();
                        foreach (ClubMember member in members.Records)
                        {
                            memberIDs.Add(member.UserID);
                        }
                        ClubActivities.SendToClubMembers(clubActivity.ActivityID, ApplicationIDs.Instance().Forum(), memberIDs);
                    }
                }
                #endregion

            }
        }

        #endregion
        /// <summary>
        /// 获取帖子的可见性
        /// </summary>
        private static bool GetIsPublic(ForumThread forumThread)
        {
            if (forumThread.GroupID <= 0)
                return false;
            ForumSectionGroup group = ForumSectionGroups.GetGroup(forumThread.GroupID, false);
            bool forumThreadIsPublic = false;
            if (group.PresentAreaID == PresentAreaIDs.Instance().Channel())
            {
                if (Applications.IsEnabled(ApplicationIDs.Instance().Forum()))
                {
                    if (forumThread.AuditingStatus == AuditingStatuses.Success)
                        forumThreadIsPublic = true;
                }
            }
            else if (group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
            {
                if (Applications.IsEnabled(ApplicationIDs.Instance().Club()))
                {

                    Club.Club club = Clubs.GetClub(group.OwnerID, false);
                    if (club != null && club.IsPublic && forumThread.AuditingStatus == AuditingStatuses.Success)
                        forumThreadIsPublic = true;
                }
            }

            return forumThreadIsPublic;
        }

        /// <summary>
        /// 获取带链接的博客文章或评论的html代码
        /// </summary>
        private static string GetForumPostSubjectWithHyperlink(ForumThread forumThread, ForumPost child)
        {
            string navigateUrl = string.Empty;

            if (forumThread.GroupID <= 0)
                return string.Empty;
            ForumSectionGroup group = ForumSectionGroups.GetGroup(forumThread.GroupID, false);

            if (group.PresentAreaID == PresentAreaIDs.Instance().Channel())
            {
                if (Applications.IsEnabled(ApplicationIDs.Instance().Forum()))
                {
                    if (child != null)
                        navigateUrl = SiteUrls.Instance().ShowForumThreadGotoLastPost(forumThread.ThreadID, child.PostID);
                    else
                        navigateUrl = SiteUrls.Instance().ShowForumThread(forumThread.ThreadID);
                }
            }
            else
            {
                if (Applications.IsEnabled(ApplicationIDs.Instance().Club()))
                {
                    Club.Club club = Clubs.GetClub(group.OwnerID, false);
                    if (child != null)
                        navigateUrl = SiteUrls.Instance().ShowForumThreadGotoLastPostInClub(club.DomainName, forumThread.ThreadID, child.PostID);
                    else
                        navigateUrl = SiteUrls.Instance().ShowForumThreadInClub(club.DomainName, forumThread.ThreadID);
                }
            }
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserStory, navigateUrl, forumThread.Subject);
        }

        private static readonly string HyperlinkTargetOfUserStory = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;

    }
}
