﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights  reserved.
// </copyright> 
//------------------------------------------------------------------------------ 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Club;

namespace SpaceBuilder.Forum.Modules
{
    /// <summary>
    /// 删除群组时处理投票
    /// </summary>
    public class DisposeForumForDeleteClub : IClubModule
    {
        #region IClubModule 成员

        public void Init(ClubEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.BeforeClubChange += new ClubEventHandler(em_BeforeClubChange);
        }

        void em_BeforeClubChange(SpaceBuilder.Club.Club club, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Delete)
            {
                ForumSectionGroup group = ForumSectionGroups.GetGroup(OwnerID2GroupIDDictionary.Instance(PresentAreaIDs.Instance().ClubDomain()).GetGroupID(club.ClubID), true);
                if (group != null)
                {
                    //删除群组论坛版块
                    IList<ForumSection> sections = ForumSections.GetIndentedSectionsOfGroup(group.GroupID, null);
                    if (sections != null)
                    {
                        foreach (var section in sections)
                        {
                            ForumSections.Delete(section);
                        }
                    }

                    //删除群组论坛版块组
                    ForumSectionGroups.DeleteGroup(group);
                }
            }
        }

        #endregion
    }
}
