//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights  reserved.
// </copyright> 
//------------------------------------------------------------------------------ 


using System;
using System.Collections.Generic;
using System.Text;
using SpaceBuilder.Forum;

using SpaceBuilder.Common.Mail;
using SpaceBuilder.Common;
using SpaceBuilder.Club;
using SpaceBuilder.Utils;
using SpaceBuilder.Web;

namespace SpaceBuilder.Forum.Modules
{
    /// <summary>
    /// ̳ص֪ͨ
    /// </summary>
    public class DisposeNoticeForForum : IForumModule
    {
        #region IForumModule Ա

        public void Init(ForumEventManager eventManager, System.Xml.Linq.XElement node)
        {
            eventManager.AfterForumPostChange += new ForumPostEventHandler(eventManager_AfterForumPostChange);
        }

        void eventManager_AfterForumPostChange(ForumPost forumPost, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().Forum()) && (e.State == ObjectState.Create))
            {
                User user = Users.GetUser(forumPost.UserID, false);
                if (user == null)
                    return;
                if (forumPost.ParentID == 0)
                    return;
                ForumThread forumThread = ForumThreads.GetThread(forumPost.ThreadID, false);
                ForumPost parentPost = ForumPosts.GetPost(forumPost.ParentID, false);
                if (forumThread == null || parentPost == null || (parentPost.UserID == forumPost.UserID))
                    return;
                User toUser = Users.GetUser(parentPost.UserID, false);
                if (toUser == null)
                    return;
                string itemKey = NoticeItemKeys.Instance().NewForumPost();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().Forum();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.UserID = parentPost.UserID;
                record.Receiver = parentPost.Author;
                record.LeadingActorUserID = user.UserID;
                record.LeadingActor = user.DisplayName;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Forum());
                record.RelativeItemID = forumThread.ThreadID;
                record.RelativeItemName = forumThread.Subject;
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewForumPost", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user, true),
                GetForumPostSubjectWithHyperlink(forumThread, forumPost));
                record.RelativeItemUrl = GetForumUrl(forumThread, forumPost);
                record.Body = forumPost.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        /// <summary>
        /// ȡӵ̳ӵhtml
        /// </summary>
        private static string GetForumPostSubjectWithHyperlink(ForumThread forumThread, ForumPost child)
        {
            if (forumThread.GroupID <= 0)
                return forumThread.Subject;

            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserStory, GetForumUrl(forumThread, child), forumThread.Subject);
        }

        /// <summary>
        /// ȡ̳ӵӵַ
        /// </summary>
        private static string GetForumUrl(ForumThread forumThread, ForumPost child)
        {
            string navigateUrl = string.Empty;

            ForumSectionGroup group = ForumSectionGroups.GetGroup(forumThread.GroupID, false);
            if (group == null)
                return navigateUrl;

            if (group.PresentAreaID == PresentAreaIDs.Instance().Channel() && Applications.IsEnabled(ApplicationIDs.Instance().Forum()))
            {
                if (child != null)
                    navigateUrl = SiteUrls.Instance().ShowForumThreadGotoLastPost(forumThread.ThreadID, child.PostID);
                else
                    navigateUrl = SiteUrls.Instance().ShowForumThread(forumThread.ThreadID);
            }

            if (group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain() && Applications.IsEnabled(ApplicationIDs.Instance().Club()))
            {
                Club.Club club = Clubs.GetClub(group.OwnerID, false);
                if (child != null)
                    navigateUrl = SiteUrls.Instance().ShowForumThreadGotoLastPostInClub(club.DomainName, forumThread.ThreadID, child.PostID);
                else
                    navigateUrl = SiteUrls.Instance().ShowForumThreadInClub(club.DomainName, forumThread.ThreadID);
            }

            return navigateUrl;
        }

        private static readonly string HyperlinkTargetOfUserStory = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;


        #endregion
    }
}
