//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Forum;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.Forum.Modules
{
    /// <summary>
    /// ̳صĻ
    /// </summary>
    public class DisposePointForForum : IForumModule
    {
        #region IForumModule Ա

        public void Init(ForumEventManager eventManager, System.Xml.Linq.XElement node)
        {
            //eventManager.AfterForumThreadChange += new ForumThreadEventHandler(eventManager_AfterForumThreadChange);
            //eventManager.AfterForumPostChange += new ForumPostEventHandler(eventManager_AfterForumPostChange);
            eventManager.SetForumThreadSpecial += new ForumThreadSpecialEventHandler(eventManager_SetForumThreadSpecial);
            eventManager.AfterPointChangeOfForumPost += new PointChangeOfForumPostHandler(eventManager_AfterPointChangeOfForumPost);
            eventManager.AfterPointChangeOfForumThread += new PointChangeOfForumThreadHandler(eventManager_AfterPointChangeOfForumThread);

        }

        void eventManager_AfterPointChangeOfForumThread(ForumThread forumThread, GlobalEventArgs e, UserPointDirection userPointDirection)
        {

            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            User user = Users.GetUser(forumThread.UserID, false);
            if (user == null)
                return;
            if (userPointDirection == UserPointDirection.Input)
            {
                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateForumThread());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateForumThread", user.Language, e.ApplicationID), forumThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ForumThreadAuditingSuccess", user.Language, e.ApplicationID), forumThread.Subject);
            }
            else
            {
                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteForumThread());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteForumThread", user.Language, e.ApplicationID), forumThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ForumThreadAuditingFail", user.Language, e.ApplicationID), forumThread.Subject);
            }
            if (role == null)
                return;
            if (role.HasTradePoints)
            {
                ForumUserDatas.ChanageExperiencePoints(user.UserID, role.TradePoints);
            }

            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, forumThread.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            SpaceBuilder.Common.Points.CreateUserPointRecords(records);
        }

        void eventManager_AfterPointChangeOfForumPost(ForumPost forumPost, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;

            if (userPointDirection == UserPointDirection.Input)
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateForumPost());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateForumPost", Globals.GetCurrentUserLanguage(), e.ApplicationID), forumPost.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ForumPostAuditingSuccess", Globals.GetCurrentUserLanguage(), e.ApplicationID), forumPost.Subject);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteForumPost());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteForumPost", Globals.GetCurrentUserLanguage(), e.ApplicationID), forumPost.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_ForumPostAuditingFail", Globals.GetCurrentUserLanguage(), e.ApplicationID), forumPost.Subject);
            }
            if (role == null)
                return;
            if (role.HasTradePoints)
            {
                ForumUserDatas.ChanageExperiencePoints(forumPost.UserID, role.TradePoints);
            }

            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, forumPost.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            SpaceBuilder.Common.Points.CreateUserPointRecords(records);
        }

        void eventManager_SetForumThreadSpecial(ForumThread forumThread, ForumThreadSpaceailEventArgs e)
        {
            if (e.IsDealEssential)
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;
                User user = Users.GetUser(forumThread.UserID, false);
                if (user == null)
                    return;
                role = SpaceBuilder.Common.Points.GetUserPointItemRole(UserPointItemKeys.Instance().EssentialForumThread());

                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_EssentialForumThread", user.Language, ApplicationIDs.Instance().Forum()), forumThread.Subject);

                if (role == null)
                    return;
                if (role.HasTradePoints)
                {
                    ForumUserDatas.ChanageExperiencePoints(user.UserID, role.TradePoints);
                }
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, forumThread.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                SpaceBuilder.Common.Points.CreateUserPointRecords(records);
            }
        }


        #endregion

        ///// <summary>
        ///// ̳
        ///// </summary>
        //void pem_AfterAttachmentChange(Post post, PostAttachment attachment, GlobalEventArgs e)
        //{
        //    if ((e.ApplicationType == ApplicationType.Forum) && (e.State == ObjectState.Create || e.State == ObjectState.Delete))
        //    {
        //        List<UserPointRecord> records = new List<UserPointRecord>();
        //        UserPointItem userPointItem = null;
        //        string userPointRecordDescription = string.Empty;

        //        if (e.State == ObjectState.Create)
        //        {
        //            userPointItem = SpaceBuilder.Components.Points.GetUserPointItem(UserPointItemEnum.PostForumAttachment);
        //            userPointRecordDescription = "ϴ̳" + attachment.FriendlyFileName;
        //        }
        //        else
        //        {
        //            userPointItem = SpaceBuilder.Components.Points.GetUserPointItem(UserPointItemEnum.DeleteForumAttachement);
        //            userPointRecordDescription = "ɾ̳" + attachment.FriendlyFileName;
        //        }

        //        if (userPointItem != null)
        //        {
        //            if (userPointItem.HasBasicPoints)
        //            {
        //                UserPointRecord record = new UserPointRecord();
        //                record.Description = userPointRecordDescription;
        //                record.PointCategory = UserPointCategory.Basic;
        //                record.PointItem = userPointItem.ItemID;
        //                record.Points = userPointItem.BasicPoints;
        //                record.UserID = attachment.UserID;
        //                records.Add(record);
        //            }
        //            if (userPointItem.HasReportPoints)
        //            {
        //                UserPointRecord record = new UserPointRecord();
        //                record.Description = userPointRecordDescription;
        //                record.PointCategory = UserPointCategory.Report;
        //                record.PointItem = userPointItem.ItemID;
        //                record.Points = userPointItem.ReportPoints;
        //                record.UserID = attachment.UserID;
        //                records.Add(record);
        //            }
        //            if (userPointItem.HasCreditPoints)
        //            {
        //                UserPointRecord record = new UserPointRecord();
        //                record.Description = userPointRecordDescription;
        //                record.PointCategory = UserPointCategory.Credit;
        //                record.PointItem = userPointItem.ItemID;
        //                record.Points = userPointItem.CreditPoints;
        //                record.UserID = attachment.UserID;
        //                records.Add(record);
        //            }
        //            if (userPointItem.HasTradePoints)
        //            {
        //                UserPointRecord record = new UserPointRecord();
        //                record.Description = userPointRecordDescription;
        //                record.PointCategory = UserPointCategory.Trade;
        //                record.PointItem = userPointItem.ItemID;
        //                record.Points = userPointItem.TradePoints;
        //                record.UserID = attachment.UserID;
        //                records.Add(record);
        //            }

        //            SpaceBuilder.Components.Points.CreateUserPointRecords(records);
        //        }
        //    }

        //}

    }
}
