﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc.  All rights  reserved.
// </copyright> 
//------------------------------------------------------------------------------ 


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Text.RegularExpressions;

namespace SpaceBuilder.Forum.Modules
{
    public class ForumPostFormatting : IForumModule
    {
        #region IForumModule 成员

        public void Init(ForumEventManager eventManager, System.Xml.Linq.XElement node)
        {
            eventManager.BeforeForumPostChange += new ForumPostEventHandler(eventManager_BeforeForumPostChange);
        }

        void eventManager_BeforeForumPostChange(ForumPost forumPost, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {


                //标签和脚本处理
                forumPost.Subject = Formatter.FormatSingleLinePlainTextForStorage(forumPost.Subject);
                forumPost.Body = HtmlScrubber.Clean(forumPost.Body, false, true);

                //敏感词处理
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    forumPost.Body = Censors.CensorPost(forumPost.Body);
                }
            }
        }

        #endregion
    }
}