﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;


namespace SpaceBuilder.Forum.Modules
{
    public class ForumThreadFormatting : IForumModule
    {
        #region IForumModule 成员

        public void Init(ForumEventManager eventManager, System.Xml.Linq.XElement node)
        {
            eventManager.BeforeForumThreadChange += new ForumThreadEventHandler(eventManager_BeforeForumThreadChange);
        }

        void eventManager_BeforeForumThreadChange(ForumThread forumThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                

                //标签和脚本处理
                forumThread.Subject = Formatter.FormatSingleLinePlainTextForStorage(forumThread.Subject);
                forumThread.Body = HtmlScrubber.Clean(forumThread.Body, false, true);

                //敏感词处理
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    forumThread.Body = Censors.CensorPost(forumThread.Body);
                }
            }
        }

        #endregion
    }
}
