﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Forum.Modules
{
    public class ToggleTemporaryAttachmentsForForum : IForumModule
    {

        #region IForumModule 成员

        public void Init(ForumEventManager eventManager, System.Xml.Linq.XElement xElement)
        {
            eventManager.AfterForumThreadChange += new ForumThreadEventHandler(eventManager_AfterForumThreadChange);
            eventManager.AfterForumPostChange += new ForumPostEventHandler(eventManager_AfterForumPostChange);
        }

        void eventManager_AfterForumPostChange(ForumPost forumPost, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                //将临时附件转为真实附件
                if (SPBConfig.Instance().EnableDistributedStorage)
                {
                    SpaceBuilder.Forum.Advanced.WCF.AttachmentManageClient client = new SpaceBuilder.Forum.Advanced.WCF.AttachmentManageClient("ForumToggleTemporaryAttachments");
                    client.ToggleTemporaryAttachmentsForForum(forumPost.PostID, forumPost.UserID, forumPost.SectionID);
                }
                else
                    ForumAttachmentManager.Instance().ToggleTemporaryAttachments(forumPost.PostID, forumPost.UserID, forumPost.SectionID);
            }
        }

        void eventManager_AfterForumThreadChange(ForumThread forumThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                //将临时附件转为真实附件
                if (SPBConfig.Instance().EnableDistributedStorage)
                {
                    SpaceBuilder.Forum.Advanced.WCF.AttachmentManageClient client = new SpaceBuilder.Forum.Advanced.WCF.AttachmentManageClient("ForumToggleTemporaryAttachments");
                    client.ToggleTemporaryAttachmentsForForum(forumThread.PostID, forumThread.UserID, forumThread.SectionID);
                }
                else
                {
                    ForumAttachmentManager.Instance().ToggleTemporaryAttachments(forumThread.PostID, forumThread.UserID, forumThread.SectionID);
                }
            }
        }

        #endregion
    }

}
