﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Forum
{
    /// <summary>
    /// 论坛帖子全文检索查询类
    /// </summary>
    public class ForumPostFullTextQuery
    {
        /// <summary>
        /// 搜索范围限定 GroupID
        /// </summary>
        public int SearchScopeGroupID = -1;

        /// <summary>
        /// SectionID
        /// </summary>
        public int SectionID = -1;

        /// <summary>
        /// 是否包含SectionID的子孙类别
        /// </summary>
        public bool IncludeSectionDescendant = true;

        /// <summary>
        /// UserID
        /// </summary>
        public int UserID = -1;

        /// <summary>
        /// 关键字
        /// </summary>
        public string Keyword = string.Empty;

        /// <summary>
        /// 标签
        /// </summary>
        public string TagName = null;

        public int DateScopes = (int)ForumDateScopes.ThreeMonth;

        /// <summary>
        /// 排序字段
        /// </summary>
        public FullTextQueryForumPostsSortBy SortBy = FullTextQueryForumPostsSortBy.Relevance;

        /// <summary>
        /// 当前显示页面页码
        /// </summary>
        private int pageIndex = 1;
        public int PageIndex
        {
            get
            {
                if (pageIndex < 1)
                    return 1;
                else
                    return pageIndex;
            }
            set { pageIndex = value; }
        }

        /// <summary>
        /// 每页显示记录数
        /// </summary>
        public int PageSize = 20;


        /// <summary>
        /// 从QueryString获取查询条件
        /// </summary>
        public void ConvertFromQueryString(System.Web.HttpRequestBase request)
        {
            if (!string.IsNullOrEmpty(request.QueryString["SearchScopeGroupID"]))
                int.TryParse(request.QueryString["SearchScopeGroupID"], out this.SearchScopeGroupID);

            if (!string.IsNullOrEmpty(request.QueryString["IncludeSectionDescendant"]))
                bool.TryParse(request.QueryString["IncludeSectionDescendant"], out this.IncludeSectionDescendant);

            if (!string.IsNullOrEmpty(request.QueryString["SectionID"]))
                int.TryParse(request.QueryString["SectionID"], out this.SectionID);

            if (!string.IsNullOrEmpty(request.QueryString["UserID"]))
                int.TryParse(request.QueryString["UserID"], out this.UserID);

            if (!string.IsNullOrEmpty(request.QueryString["Keyword"]))
                this.Keyword = request.QueryString["Keyword"];


            if (!string.IsNullOrEmpty(request.QueryString["TagName"]))
                this.TagName = request.QueryString["TagName"];

            if (!string.IsNullOrEmpty(request.QueryString["PaseSize"]))
                int.TryParse(request.QueryString["PaseSize"], out this.PageSize);

            if (!string.IsNullOrEmpty(request.QueryString["DateScopes"]))
                int.TryParse(request.QueryString["DateScopes"], out this.DateScopes);
        }



        /// <summary>
        /// 查询条件是否有效
        /// </summary>
        public bool IsValid()
        {
            return IsShowMoreCondition() || !string.IsNullOrEmpty(Keyword);
        }
        /// <summary>
        /// 是否需要显示更多查询选项
        /// </summary>
        public bool IsShowMoreCondition()
        {
            return SearchScopeGroupID > 0 || SectionID > 0 || UserID > 0
                                  || (TagName != null && TagName.Length > 0) || DateScopes != (int)ForumDateScopes.ThreeMonth;
        }


    }


    /// <summary>
    /// 论坛帖子全文检索排序字段
    /// </summary>
    public enum FullTextQueryForumPostsSortBy
    {
        /// <summary>
        /// 相关性
        /// </summary>
        /// <remarks>
        /// 全文索引库默认排序方式
        /// </remarks>
        Relevance = 0,

        /// <summary>
        /// 最近更新日期
        /// </summary>
        LastUpdatedDate = 1
    }

}
