﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Tasks;
using System.Xml;
using SpaceBuilder.Common;
using SpaceBuilder.Forum;

using SpaceBuilder.Club;
using SpaceBuilder.Utils;
using System.Xml.Linq;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 定期把ForumPost的变更情况更新到Lucene索引文件
    /// </summary>
    public class ForumPostIndexTask : TaskBase
    {
        /// <summary>
        /// 每次更新索引的最大数目
        /// </summary>
        private int count = 1000;

        #region ITask Members

        public override void ExecuteTask(XElement xElement)
        {
            XAttribute countNode = xElement.Attribute("count");
            if (countNode != null)
            {
                int.TryParse(countNode.Value, out count);
            }
            IndexPosts(count);
        }

        #endregion

        private void IndexPosts(int count)
        {
            SearchDataProvider dp = SearchDataProvider.Instance();
            IList<ItemForIndex> itemsForIndex = dp.GetItemsForIndex(ForumSearchTypeSettings.CODE, count);
            IList<ItemForIndex> createItems = new List<ItemForIndex>();
            IList<ItemForIndex> updateItems = new List<ItemForIndex>();
            IList<ItemForIndex> deleteItems = new List<ItemForIndex>();

            foreach (ItemForIndex item in itemsForIndex)
            {
                if (item.DataAction == ObjectState.Create)
                    createItems.Add(item);
                else if (item.DataAction == ObjectState.Update)
                    updateItems.Add(item);
                else if (item.DataAction == ObjectState.Delete)
                    deleteItems.Add(item);
            }

            ForumSearchManager searchManager = ForumSearchManager.Instance();
            #region Insert

            IList<ForumThread> createPosts = new List<ForumThread>();
            foreach (ItemForIndex item in createItems)
            {
                ForumThread thread = ForumThreads.GetThread(item.ItemID, true);
                if (thread != null)
                    createPosts.Add(thread);
            }

            if (searchManager.Insert(createPosts))
            {
                dp.DeleteItemsForIndex(createItems);
            }
            else
            {
                foreach (ItemForIndex item in createItems)
                {
                    item.DataAction = ObjectState.Update;
                }
                dp.UpdateItemsForIndex(createItems);
            }

            #endregion

            #region Update

            IList<ForumThread> updatePosts = new List<ForumThread>();
            foreach (ItemForIndex item in updateItems)
            {
                ForumThread thread = ForumThreads.GetThread(item.ItemID, true);
                if (thread != null)
                    updatePosts.Add(thread);
            }

            if (searchManager.Update(updatePosts, m => m.Select(n => n.ThreadID).ToList(), ForumIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(updateItems);
            }

            #endregion

            #region Delete
            if (deleteItems.Count > 0 && searchManager.Delete(deleteItems.Select(n => n.ItemID).ToList(), ForumIndexFields.ThreadID))
            {
                dp.DeleteItemsForIndex(deleteItems);
            }
            #endregion
        }

    }
}