﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Forum;
using SpaceBuilder.Common;

namespace SpaceBuilder.LuceneSearch
{
    /// <summary>
    /// 处理ForumThread的变更，把变更情况记录到数据库，并在<see cref="SpaceBuilder.LuceneSearch.ForumThreadIndexTask"/>批量更新到Lucene索引文件中
    /// </summary>
    public class PrepareForForumThreadIndexModule : IForumModule
    {
        #region IForumModule 成员

        public void Init(ForumEventManager eventManager, System.Xml.Linq.XElement node)
        {
            eventManager.AfterForumThreadChange += new ForumThreadEventHandler(eventManager_AfterForumThreadChange);

            //eventManager.AfterForumPostChange += new ForumPostEventHandler(eventManager_AfterForumPostChange);
        }


        void eventManager_AfterForumThreadChange(ForumThread forumThread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if ((forumThread != null) && (e.State == ObjectState.Create || e.State == ObjectState.Update || e.State == ObjectState.Delete))
            {
                ItemForIndex item = new ItemForIndex();
                item.ItemID = forumThread.ThreadID;
                if (forumThread.GroupID > 0)
                    item.ClubID = forumThread.GroupID;

                item.SearchTypeCode = ForumSearchTypeSettings.CODE;
                item.DataAction = e.State;

                SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
            }
        }

        void eventManager_AfterForumPostChange(ForumPost forumPost, GlobalEventArgs e)
        {
            //if ((forumPost != null) && (e.State == ObjectState.Create || e.State == ObjectState.Update || e.State == ObjectState.Delete))
            //{
            //    ItemForIndex item = new ItemForIndex();
            //    item.ItemID = forumPost.PostID;

            //    ForumThread forumThread = ForumThreads.GetThread(forumPost.ThreadID);
            //    if (forumThread == null)
            //        return;
            //    if (forumThread.ClubID > 0)
            //        item.ClubID = forumThread.ClubID;

            //    item.SearchTypeCode = ForumSearchTypeSettings.CODE;
            //    item.DataAction = e.State;

            //    SearchDataProvider.Instance().CreateUpdateDeleteItemForIndex(item, DataProviderAction.Create);
            //}
        }

        #endregion
    }

}
