﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Forum
{
    public static class SiteUrlsExtensions
    {

        #region Froum

        /// <summary>
        /// 下载或查看附件
        /// </summary>
        public static string DownloadForumAttachment(this SiteUrls siteUrls, int attachmentID)
        {
            if (FileStorageProvider.Instance(ForumAttachmentManager.Instance().StorageProviderName).EnableDirectlyUrl)
            {
                Attachment attachment = ForumAttachmentManager.Instance().GetAttachment(attachmentID, false);
                if (attachment == null)
                    return string.Empty;

                if (attachment.IsImage)
                    return ForumAttachmentManager.Instance().GetDirectlyUrl(attachment);
            }

            return Globals.GetFullUrlInFileHandlerSite(ForumAttachmentManager.Instance().StorageProviderName, string.Format("~/Services/ForumAttachment.ashx?AttachmentID={0}", attachmentID));
        }

        /// <summary>
        /// 删除论坛附件Url
        /// </summary>
        public static string DeleteForumAttachmentUrl(this SiteUrls siteUrls, int attachmentID, bool? isImage)
        {
            return SPBUrlHelper.RouteUrl("Common", new RouteValueDictionary { { "controller", "ChannelForum" }, { "action", "DeleteForumAttachment" }, { "attachmentID", attachmentID }, { "isImage", isImage } });
        }


        /// <summary>
        ///  RSS订阅论坛版块
        /// </summary>
        public static string ForumRss(this SiteUrls siteUrls, int forumSectionID)
        {
            return ForumRss(siteUrls, forumSectionID, ForumThreadSortBy.LastRepliedDate, null);
        }

        /// <summary>
        ///  RSS订阅论坛版块
        /// </summary>
        public static string ForumRss(this SiteUrls siteUrls, int forumSectionID, ForumThreadSortBy? sortBy, bool? isEssential)
        {
            return WebUtils.ResolveUrl(string.Format("~/Services/Forum/ForumRss.ashx?SectionID={0}&SortBy={1}&IsEssential={2}", forumSectionID, (int)(sortBy ?? ForumThreadSortBy.HitTimes), isEssential));
        }

        /// <summary>
        /// 显示论坛主题及回复,并定位到最后一个帖子
        /// </summary>
        public static string ShowForumThreadGotoLastPost(this SiteUrls siteUrls, int threadID, int anchorPostID)
        {
            return WebUtils.ResolveUrl(String.Format("~/Services/Forum/ForumUrl.ashx?EspecialUrlType=1&ThreadID={0}&anchorPostID={1}", threadID, anchorPostID));
        }

        /// <summary>
        /// 群组论坛 显示论坛主题及回复,并定位到最后一个帖子
        /// </summary>
        public static string ShowForumThreadGotoLastPostInClub(this SiteUrls siteUrls, string clubDomainName, int threadID, int anchorPostID)
        {
            return WebUtils.ResolveUrl(String.Format("~/Services/Forum/ForumUrl.ashx?EspecialUrlType=1&ClubDomainName={0}&ThreadID={1}&anchorPostID={2}", clubDomainName, threadID, anchorPostID));
        }

        /// <summary>
        /// 版块Logo图片地址
        /// </summary>
        public static string ForumSectionLogoUrl(this SiteUrls siteUrls, ForumSection section)
        {
            if (FileStorageProvider.Instance(ForumSections.StorageProviderName).EnableDirectlyUrl)
            {
                return ForumSections.GetSectionPhotoDirectlyUrl(section);
            }

            return Globals.GetFullUrlInFileHandlerSite(ConvertibleGifts.StorageProviderName, string.Format("~/Services/Forum/ForumSectionLogo.ashx?sectionID={0}", section.SectionID));
        }


        #endregion



        #region 需重复配置的URL

        /// <summary>
        /// 论坛频道首页
        /// </summary>
        public static string ChannelForumHome(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_Forum_Home");
        }

        /// <summary>
        /// 显示版块组
        /// </summary>
        public static string ShowForumGroup(this SiteUrls siteUrls, int groupID)
        {
            return SPBUrlHelper.RouteUrl("Channel_Forum_ShowForumGroup", new RouteValueDictionary { { "groupID", groupID } });
        }

        /// <summary>
        /// 显示论坛版块
        /// </summary>
        public static string ShowForumSection(this SiteUrls siteUrls, int sectionID)
        {
            return ShowForumSection(siteUrls, sectionID, 0);
        }
        /// <summary>
        /// 显示论坛版块
        /// </summary>
        public static string ShowForumSection(this SiteUrls siteUrls, int sectionID, int categoryID)
        {
            if (categoryID > 0)
                return SPBUrlHelper.RouteUrl("Channel_Forum_ShowForumSection", new RouteValueDictionary { { "sectionID", sectionID }, { "categoryID", categoryID } });
            else
                return SPBUrlHelper.RouteUrl("Channel_Forum_ShowForumSection", new RouteValueDictionary { { "sectionID", sectionID } });
        }


        /// <summary>
        /// 显示论坛主题(独立论坛)
        /// </summary>
        public static string ShowForumThread(this SiteUrls siteUrls, int threadID)
        {
            return ShowForumThread(siteUrls, threadID, null, null);
        }

        /// <summary>
        /// 显示论坛主题
        /// </summary>
        public static string ShowForumThread(this SiteUrls siteUrls, int threadID, int? replyUserID, bool? isDesc)
        {
            RouteValueDictionary dictionary = new RouteValueDictionary { { "threadID", threadID } };
            if (replyUserID.HasValue && replyUserID.Value > 0)
                dictionary["replyUserID"] = replyUserID;
            if (isDesc.HasValue && isDesc.Value)
                dictionary["isDesc"] = isDesc;
            return SPBUrlHelper.RouteUrl("Channel_Forum_ShowForumThread", dictionary);
        }

        /// <summary>
        /// 显示论坛主题(独立论坛)
        /// </summary>
        public static string ShowForumThreadReply(this SiteUrls siteUrls, int threadID)
        {
            return ShowForumThread(siteUrls, threadID) + "#quickReply";
        }

        /// <summary>
        /// 分页显示论坛主题及回复
        /// </summary>
        public static string ShowForumThreadPaged(this SiteUrls siteUrls, int threadID, int pageIndex)
        {
            return SPBUrlHelper.RouteUrl("Channel_Forum_ShowForumThread", new RouteValueDictionary { { "threadID", threadID }, { "pageIndex", pageIndex } });
        }

        /// <summary>
        /// 分页显示论坛主题及回复,并定位到相应锚点
        /// </summary>
        public static string ShowForumThreadPaged(this SiteUrls siteUrls, int threadID, int pageIndex, int anchorPostID)
        {
            string strPageIndex = string.Format("{0}&anchor=#{1}", pageIndex, anchorPostID);
            return SPBUrlHelper.RouteUrl("Channel_Forum_ShowForumThread", new RouteValueDictionary { { "threadID", threadID }, { "pageIndex", strPageIndex } });
        }

        #region 群组论坛

        /// <summary>
        /// 显示论坛版块
        /// </summary>
        public static string ShowForumSectionInClub(this SiteUrls siteUrls, string clubDomainName, int sectionID)
        {
            return ShowForumSectionInClub(siteUrls, clubDomainName, sectionID, 0);
        }
        /// <summary>
        /// 显示论坛版块
        /// </summary>
        public static string ShowForumSectionInClub(this SiteUrls siteUrls, string clubDomainName, int sectionID, int categoryID)
        {
            if (categoryID > 0)
                return SPBUrlHelper.RouteUrl("ClubDomain_Forum_Common", new RouteValueDictionary { { "ClubDomainName", clubDomainName }, { "action", "ShowForumSection" }, { "sectionID", sectionID }, { "categoryID", categoryID } });
            else
                return SPBUrlHelper.RouteUrl("ClubDomain_Forum_Common", new RouteValueDictionary { { "ClubDomainName", clubDomainName }, { "action", "ShowForumSection" }, { "sectionID", sectionID } });
        }


        /// <summary>
        /// 群组内显示论坛主题
        /// </summary>
        public static string ShowForumThreadInClub(this SiteUrls siteUrls, string clubDomainName, int threadID)
        {
            return SPBUrlHelper.RouteUrl("ClubDomain_Forum_Common", new RouteValueDictionary { { "ClubDomainName", clubDomainName }, { "action", "ShowForumThread" }, { "threadID", threadID } });
        }

        /// <summary>
        /// 群组论坛分页显示帖子
        /// </summary>
        public static string ShowForumThreadPagedInClub(this SiteUrls siteUrls, string clubDomainName, int threadID, int pageIndex)
        {
            return SPBUrlHelper.RouteUrl("ClubDomain_Forum_Common", new RouteValueDictionary { { "ClubDomainName", clubDomainName }, { "action", "ShowForumThread" }, { "threadID", threadID }, { "pageIndex", pageIndex } });
        }

        /// <summary>
        /// 群组 论坛 分页显示论坛主题及回复,并定位到相应锚点
        /// </summary>
        public static string ShowForumThreadPagedAndPermLinkInClub(this SiteUrls siteUrls, string clubDomainName, int threadID, int pageIndex, int anchorPostID)
        {
            string strPpageIndex = string.Format("{0}&anchor=#{1}", pageIndex, anchorPostID);
            return SPBUrlHelper.RouteUrl("ClubDomain_Forum_Common", new RouteValueDictionary { { "ClubDomainName", clubDomainName }, { "action", "ShowForumThread" }, { "threadID", threadID }, { "pageIndex", strPpageIndex } });
        }

        #endregion

        #region PresentArea

        /// <summary>
        /// 显示论坛主题,未确定在何种表现区域下显示时调用
        /// </summary>
        public static string ShowForumThreadInPresentArea(this SiteUrls siteUrls, ForumThread thread)
        {
            if (thread == null)
                return string.Empty;

            ForumSectionGroup group = ForumSectionGroups.GetGroup(thread.GroupID, false);
            if (group == null)
                return string.Empty;
            if (group.PresentAreaID == PresentAreaIDs.Instance().Channel())
                return ShowForumThread(siteUrls, thread.ThreadID);
            else if (group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                return ShowForumThreadInClub(siteUrls, Club.ClubID2ClubNameDictionary.GetClubDomainName(OwnerID2GroupIDDictionary.Instance(group.PresentAreaID).GetOwnerID(group.GroupID)), thread.ThreadID);
            return string.Empty;
        }
        /// <summary>
        /// 显示论坛主题,未确定在何种表现区域下显示时调用
        /// </summary>
        public static string ShowForumThreadPagedInPresentArea(this SiteUrls siteUrls, ForumThread thread, int pageIndex)
        {
            return ShowForumThreadPagedInPresentArea(siteUrls, thread, pageIndex, 0);
        }
        /// <summary>
        /// 显示论坛主题,未确定在何种表现区域下显示时调用
        /// </summary>
        public static string ShowForumThreadPagedInPresentArea(this SiteUrls siteUrls, ForumThread thread, int pageIndex, int anchorPostID)
        {
            if (thread == null)
                return string.Empty;

            ForumSectionGroup group = ForumSectionGroups.GetGroup(thread.GroupID, false);
            if (group == null)
                return string.Empty;
            if (group.PresentAreaID == PresentAreaIDs.Instance().Channel())
                return ShowForumThreadPaged(siteUrls, thread.ThreadID, pageIndex, anchorPostID);
            else if (group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                return ShowForumThreadPagedInClub(siteUrls, Club.ClubID2ClubNameDictionary.GetClubDomainName(OwnerID2GroupIDDictionary.Instance(group.PresentAreaID).GetOwnerID(group.GroupID)), thread.ThreadID, pageIndex);
            return string.Empty;
        }

        /// <summary>
        /// 显示论坛主题及回复,并定位到最后一个帖子
        /// </summary>
        public static string ShowForumThreadGotoLastPostInPresentArea(this SiteUrls siteUrls, ForumThread thread, int anchorPostID)
        {
            if (thread == null)
                return string.Empty;

            ForumSectionGroup group = ForumSectionGroups.GetGroup(thread.GroupID, false);
            if (group == null)
                return string.Empty;
            if (group.PresentAreaID == PresentAreaIDs.Instance().Channel())
                return ShowForumThreadGotoLastPost(siteUrls, thread.ThreadID, anchorPostID);
            else if (group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                return ShowForumThreadGotoLastPostInClub(siteUrls, Club.ClubID2ClubNameDictionary.GetClubDomainName(OwnerID2GroupIDDictionary.Instance(group.PresentAreaID).GetOwnerID(group.GroupID)), thread.ThreadID, anchorPostID);
            return string.Empty;
        }

        /// <summary>
        /// 显示论坛版块,未确定在何种表现区域下显示时调用
        /// </summary>
        public static string ShowForumSectionInPresentArea(this SiteUrls siteUrls, ForumSection section)
        {
            if (section == null)
                return string.Empty;
            ForumSectionGroup group = ForumSectionGroups.GetGroup(section.GroupID, false);
            if (group == null)
                return string.Empty;
            if (group.PresentAreaID == PresentAreaIDs.Instance().Channel())
                return ShowForumSection(siteUrls, section.SectionID);
            else if (group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                return ShowForumSectionInClub(siteUrls, Club.ClubID2ClubNameDictionary.GetClubDomainName(OwnerID2GroupIDDictionary.Instance(group.PresentAreaID).GetOwnerID(group.GroupID)), section.SectionID);
            return string.Empty;
        }

        /// <summary>
        /// 显示论坛版块,未确定在何种表现区域下显示时调用
        /// </summary>
        public static string ShowForumSectionGroupInPresentArea(this SiteUrls siteUrls, ForumSectionGroup group)
        {
            if (group == null)
                return string.Empty;
            if (group.PresentAreaID == PresentAreaIDs.Instance().Channel())
                return ShowForumGroup(siteUrls, group.GroupID);
            else if (group.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                return siteUrls.ClubDomainHome(Club.ClubID2ClubNameDictionary.GetClubDomainName(OwnerID2GroupIDDictionary.Instance(group.PresentAreaID).GetOwnerID(group.GroupID)));
            return string.Empty;
        }

        #endregion

        #endregion

        /// <summary>
        /// 根据站点标签列表显示文件
        /// </summary>
        public static string ListForumThreadsByTag(this SiteUrls siteUrls, string tagName)
        {
            return SPBUrlHelper.Action("Search", "ChannelForum", new RouteValueDictionary { { "TagName", WebUtils.UrlEncode(tagName) } });
        }
    }
}
