﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.Mvc;
using SpaceBuilder.Common.Controllers;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using System.Web.Routing;
using SpaceBuilder.Utils;

namespace SpaceBuilder.MicroBlog.Controllers
{
    [ManageAuthorize]
    [HttpCompress]
    public class ManageMicroBlogController : ManageControllerBase
    {

        #region MicroBlogThread

        /// <summary>
        /// 微博主题列表
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageMicroBlogThreads(AuditingStatusesForDisplay? status, int? PageIndex)
        {
            SetPageTitle("微博主题管理");

            if (!PageIndex.HasValue || PageIndex.Value <= 0)
                PageIndex = 1;

            PagingDataSet<MicroBlogThread> BlogThreadsDataSet = MicroBlogThreads.GetThreadsForAdmin(20, PageIndex ?? 1, status ?? AuditingStatusesForDisplay.Pending, Request.QueryString.GetString("bodyKeywords", string.Empty), Request.QueryString.GetString("author", string.Empty), Request.QueryString.GetInt("OwnerUserID", -1));
            ViewData["status"] = status ?? AuditingStatusesForDisplay.Pending;
            return View("Pages/MicroBlog/MicroBlogThreads.aspx", "Masters/MicroBlog.master", BlogThreadsDataSet);
        }

        /// <summary>
        /// 批量删除主题或评论
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteBlogThreadsOrComments(string returnUrl, MicroBlogThreadOrComment? DelCate)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }

                    if (DelCate.HasValue && Enum.Equals(DelCate.Value, MicroBlogThreadOrComment.Comments))
                    {
                        MicroBlogComments.DeleteComments(ListThreadID);
                    }
                    else if (DelCate.HasValue && Enum.Equals(DelCate.Value, MicroBlogThreadOrComment.Threads))
                    {
                        MicroBlogThreads.DeleteThreads(ListThreadID);

                    }
                    TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                    TempData["StatusMessageContent"] = "批量删除成功";

                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "请选中以下要操作的内容";
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 删除单条主题
        /// </summary>        
        public ActionResult DeleteThread(int threadID, string returnUrl)
        {
            MicroBlogThreads.DeleteThread(threadID);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "删除成功";
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 删除评论
        /// </summary>      
        public ActionResult DeleteComment(int commentID, string returnUrl)
        {
            MicroBlogComments.DeleteComment(commentID);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "删除成功";
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 删除话题
        /// </summary>        
        public ActionResult DeleteTopic(int topicID, string returnUrl)
        {
            MicroBlogTopics.DeleteTopic(topicID);
            TempData["StatusMessageType"] = (int)StatusMessageType.Success;
            TempData["StatusMessageContent"] = "删除成功";
            return Redirect(returnUrl);
        }
        #endregion

        #region MicroBlogTopic

        /// <summary>
        /// 微博话题列表
        /// </summary>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageMicroBlogTopics(string bodyKeyword, bool? isFeatured, int? pageIndex)
        {
            SetPageTitle("微博话题管理");

            if (!pageIndex.HasValue || pageIndex.Value <= 0)
                pageIndex = 1;

            PagingDataSet<MicroBlogTopic> topics = MicroBlogTopics.GetTopicesForAdmin(bodyKeyword, isFeatured, 20, pageIndex ?? 1);
            ViewData["isFeatured"] = isFeatured;
            TempData["bodyKeyword"] = bodyKeyword;
            return View("Pages/MicroBlog/MicroBlogTopics.aspx", "Masters/MicroBlog.master", topics);
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult SreachMicroBlogTopics()
        {
            return RedirectToAction("ManageMicroBlogTopics", new RouteValueDictionary { { "bodyKeyword", Request.Form.GetString("bodyKeyword", string.Empty) } });
        }

        /// <summary>
        /// 批量删除话题
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteMicroBlogTopics(string returnUrl)
        {
            string selectedTopicIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedTopicIDsString))
            {
                string[] selectedTopicIDsStringArray = selectedTopicIDsString.Split(',');
                if (selectedTopicIDsStringArray != null && selectedTopicIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> listTopicID = new List<int>();
                    foreach (string id in selectedTopicIDsStringArray)
                    {
                        threadID = int.Parse(id);
                        listTopicID.Add(threadID);
                    }

                    try
                    {
                        MicroBlogTopics.DeleteTopics(listTopicID);
                        TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                        TempData["StatusMessageContent"] = "批量删除成功";
                    }
                    catch
                    {
                        TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                        TempData["StatusMessageContent"] = "批量删除失败";
                    }
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "请选中以下要操作的内容";
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 编辑话题
        /// </summary>
        public ActionResult EditTopic(int? topicID)
        {
            SetPageTitle(topicID.HasValue && topicID.Value > 0 ? "编辑微博话题" : "创建话题");
            MicroBlogFeaturedTopic topic = null;
            if (TempData["Topic"] != null)
                topic = TempData["Topic"] as MicroBlogFeaturedTopic;
            else
            {
                if (topicID.HasValue)
                    topic = MicroBlogTopics.GetMicroBlogTopic(topicID ?? 0, true) as MicroBlogFeaturedTopic;
                else
                    topic = new MicroBlogFeaturedTopic();
            }
            return View("Pages/MicroBlog/EditTopic.aspx", "Masters/MicroBlog.master", topic);
        }

        /// <summary>
        /// 更新话题
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateTopic(string returnUrl)
        {

            TempData["returnPreUrl"] = Request.Form.GetString("returnPreUrl", string.Empty);
            int topicID = Request.Form.GetInt("topicID", 0);
            MicroBlogFeaturedTopic topic = null;
            if (topicID > 0)
            {
                topic = MicroBlogTopics.GetMicroBlogTopic(topicID, true) as MicroBlogFeaturedTopic;
                if (topic == null)
                {
                    TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                    TempData["StatusMessageContent"] = "话题不存在或已被删除！";
                    return Redirect(returnUrl);

                }
            }
            else
            {
                topic = new MicroBlogFeaturedTopic();
                topic.Body = Request.Form.GetString("body", string.Empty);
            }
            topic.Title = Request.Form.GetString("Title", string.Empty);
            topic.Description = Request.Form.GetString("Description", string.Empty);
            topic.UserNames = Request.Form.GetString("UserNames", string.Empty);
            topic.IsFeatured = Request.Form.GetBool("IsFeatured", false);
            TempData["Topic"] = topic;

            if (string.IsNullOrEmpty(topic.Title) || topic.Title.Length > 140)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "话题为空或超出字数限制！";
                return Redirect(returnUrl);
            }

            if (topic.Description.Length > 500)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "话题描述文字超出字数限制！";
                return Redirect(returnUrl);
            }

            if (topic.UserNames.Length > 200)
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "关联微博超出字数限制！";
                return Redirect(returnUrl);
            }

            System.Web.HttpPostedFileBase picFile = null;
            if (Request.Files != null && Request.Files.Count > 0)
                picFile = Request.Files[0];

            try
            {
                if (topicID > 0)
                    MicroBlogTopics.UpdateTopic(topic, picFile);
                else
                    MicroBlogTopics.CreateTopic(topic, picFile);
                TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                TempData["StatusMessageContent"] = topicID > 0 ? "更新话题成功" : "创建话题成功";

            }
            catch
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = topicID > 0 ? "更新话题失败！" : "创建话题失败";

            }

            return Redirect(returnUrl);
        }

        #endregion

        #region MicroBlogComment

        /// <summary>
        /// 批量更新主题或评论状态
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateThreadorCommentStatus(string returnUrl, AuditingStatuses auditingStatus, MicroBlogThreadOrComment ActionCate)
        {
            string selectedThreadIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedThreadIDsString))
            {
                string[] selectedThreadIDsStringArray = selectedThreadIDsString.Split(',');
                if (selectedThreadIDsStringArray != null && selectedThreadIDsStringArray.Length > 0)
                {
                    int threadID;
                    List<int> ListThreadID = new List<int>();
                    foreach (string Id in selectedThreadIDsStringArray)
                    {
                        try
                        {
                            threadID = int.Parse(Id);
                            ListThreadID.Add(threadID);
                        }
                        catch { }
                    }

                    try
                    {
                        if (Enum.Equals(ActionCate, MicroBlogThreadOrComment.Comments))
                        {
                            MicroBlogComments.UpdateCommentAuditingStatuses(ListThreadID, auditingStatus);
                        }
                        else if (Enum.Equals(ActionCate, MicroBlogThreadOrComment.Threads))
                        {
                            MicroBlogThreads.UpdateThreadAuditingStatuses(ListThreadID, auditingStatus);
                        }
                        TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                        TempData["StatusMessageContent"] = "批量操作成功";
                    }
                    catch
                    {
                        TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                        TempData["StatusMessageContent"] = "批量操作失败";
                    }
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "请选中要操作的内容";
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 微博评论列表
        /// </summary>
        /// <returns></returns>
        [AcceptVerbs(HttpVerbs.Get)]
        public ActionResult ManageMicroBlogComments(AuditingStatusesForDisplay? status, int? PageIndex)
        {
            SetPageTitle("微博评论管理");

            int userID = Request.QueryString.GetInt("OwnerUserID", -1);
            if (!PageIndex.HasValue || PageIndex.Value <= 0)
                PageIndex = 1;
            status = status.HasValue ? status : AuditingStatusesForDisplay.Pending;
            PagingDataSet<MicroBlogComment> BlogCommentsDataSet = MicroBlogComments.GetCommentsForAdmin(userID, status, Request.QueryString.GetString("bodyKeywords", string.Empty), Request.QueryString.GetString("author", string.Empty), 17, PageIndex ?? 1);

            ViewData["status"] = status;
            return View("Pages/MicroBlog/MicroBlogComments.aspx", "Masters/MicroBlog.master", BlogCommentsDataSet);
        }

        #endregion

        #region MicroBlogScreen

        /// <summary>
        /// 管理微博大屏幕
        /// </summary>
        /// <param name="keyword"></param>
        /// <param name="userID"></param>
        /// <param name="status"></param>
        /// <param name="pageIndex"></param>
        /// <returns></returns>
        public ActionResult ManageScreens(string keyword, int? userID, AuditingStatusesForDisplay? status, int? pageIndex)
        {
            SetPageTitle("微博大屏幕管理");
            PagingDataSet<MicroBlogScreen> pds = MicroBlogScreens.GetScreensForAdmin(keyword, userID, status ?? AuditingStatusesForDisplay.Pending, 50, pageIndex ?? 1);
            ViewData["status"] = status ?? AuditingStatusesForDisplay.Pending;
            TempData["keyword"] = keyword;
            return View("Pages/MicroBlog/MicroBlogScreens.aspx", "Masters/MicroBlog.master", pds);
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult SreachMicroBlogScreen()
        {
            string keyword = Request.Form.GetString("keyword", string.Empty);
            int? userID = Request.Form.GetInt("userID", 0);
            int status = Request.Form.GetInt("status", -1);
            return RedirectToAction("ManageScreens", new RouteValueDictionary { { "keyword", keyword }, { "userID", !userID.HasValue || userID.Value <= 0 ? null : userID }, { "status", status } });
        }

        /// <summary>
        /// 批量删除话题
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult DeleteScreens(string returnUrl)
        {
            string selectedTopicIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedTopicIDsString))
            {
                string[] selectedTopicIDsStringArray = selectedTopicIDsString.Split(',');
                if (selectedTopicIDsStringArray != null && selectedTopicIDsStringArray.Length > 0)
                {
                    int screenID;
                    List<int> listScreenID = new List<int>();
                    foreach (string id in selectedTopicIDsStringArray)
                    {
                        screenID = int.Parse(id);
                        listScreenID.Add(screenID);
                    }

                    try
                    {
                        MicroBlogScreens.DeleteScreens(listScreenID);
                        TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                        TempData["StatusMessageContent"] = "批量删除成功";
                    }
                    catch
                    {
                        TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                        TempData["StatusMessageContent"] = "批量删除失败";
                    }
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "请选中要操作的内容";
            }
            return Redirect(returnUrl);
        }

        /// <summary>
        /// 删除单条主题
        /// </summary>        
        public ActionResult DeleteScreen(int screenID, string returnUrl)
        {
            if (screenID > 0)
            {
                MicroBlogScreen screen = MicroBlogScreens.GetScreen(screenID, true);
                if (screen != null)
                {
                    try
                    {
                        MicroBlogScreens.DeleteScreen(screenID);
                        TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                        TempData["StatusMessageContent"] = "删除成功";
                    }
                    catch
                    {
                        TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                        TempData["StatusMessageContent"] = "删除失败";
                    }

                }
            }
            return Redirect(returnUrl);
        }


        /// <summary>
        /// 批量更新主题或评论状态
        /// </summary>
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult UpdateScreenStatus(string returnUrl, AuditingStatuses auditingStatus)
        {
            string selectedScreenIDsString = Request.Form["CheckBoxGroup"];
            if (!string.IsNullOrEmpty(selectedScreenIDsString))
            {
                string[] selectedScreenIDsStringArray = selectedScreenIDsString.Split(',');
                if (selectedScreenIDsStringArray != null && selectedScreenIDsStringArray.Length > 0)
                {
                    int screenID;
                    List<int> ListScreenID = new List<int>();
                    foreach (string Id in selectedScreenIDsStringArray)
                    {
                        try
                        {
                            screenID = int.Parse(Id);
                            ListScreenID.Add(screenID);
                        }
                        catch { }
                    }

                    try
                    {
                        MicroBlogScreens.UpdateScreenAuditingStatuses(ListScreenID, auditingStatus);
                        TempData["StatusMessageType"] = (int)StatusMessageType.Success;
                        TempData["StatusMessageContent"] = "批量操作成功";
                    }
                    catch
                    {
                        TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                        TempData["StatusMessageContent"] = "批量操作失败";
                    }
                }
            }
            else
            {
                TempData["StatusMessageType"] = (int)StatusMessageType.Error;
                TempData["StatusMessageContent"] = "请选中要操作的内容";
            }
            return Redirect(returnUrl);
        }



        #endregion


        /// <summary>
        /// 获取微博统计数据
        /// </summary>
        public JsonResult GetManageableCounts()
        {
            Dictionary<MicroBlogManageableCounts, int> dictionary = MicroBlogThreads.GetManageableCounts();
            Application microBloggApplication = Applications.GetApplication(ApplicationIDs.Instance().MicroBlog());
            List<ManageableCount> list = new List<ManageableCount>();
            list.Add(new ManageableCount { Name = "新增微博", Value = microBloggApplication.CountInPast24Hours });
            if (dictionary.ContainsKey(MicroBlogManageableCounts.PendingThreadCount))
                list.Add(new ManageableCount { Name = "待审核微博", Value = dictionary[MicroBlogManageableCounts.PendingThreadCount], Url = SPBUrlHelper.Action("ManageMicroBlogThreads", "ManageMicroBlog", new RouteValueDictionary { { "status", AuditingStatusesForDisplay.Pending } }) });
            if (dictionary.ContainsKey(MicroBlogManageableCounts.PendingCommentCount))
                list.Add(new ManageableCount { Name = "待审核评论", Value = dictionary[MicroBlogManageableCounts.PendingCommentCount], Url = SPBUrlHelper.Action("ManageMicroBlogComments", "ManageMicroBlog", new RouteValueDictionary { { "status", AuditingStatusesForDisplay.Pending } }) });
            list.Add(new ManageableCount { Name = "总微博数", Value = microBloggApplication.TotalCount });
            return Json(list, JsonRequestBehavior.AllowGet);
        }

    }

    public enum MicroBlogSubMenus
    {
        /// <summary>
        /// 主题管理
        /// </summary>
        MicroBlogThreads = 12,

        /// <summary>
        /// 评论管理
        /// </summary>
        MicroBlogComments = 21,

        /// <summary>
        /// 话题管理
        /// </summary>
        MicroBlogTopics = 30,

        /// <summary>
        /// 大屏幕管理
        /// </summary>
        MicroBlogScreen = 40

    }

    public enum MicroBlogThreadOrComment
    {

        /// <summary>
        /// 主题
        /// </summary>
        Threads = 13,
        /// <summary>
        /// 评论
        /// </summary>
        Comments = 23

    }
}
