﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using System.IO;
using SpaceBuilder.Common.Handlers;
using SpaceBuilder.Common;

namespace SpaceBuilder.MicroBlog.Handlers
{
    /// <summary>
    /// 微博话题标题图
    /// </summary>
    public class MicroBlogTopicLogoHandler : DownloadFileHandlerBase
    {
        public override void ProcessRequest(HttpContext context)
        {
            int topicID = context.Request.QueryString.GetInt("topicID", -1);
            bool enableCaching = context.Request.QueryString.GetBool("enableCaching", true);

            if (topicID <= 0)
            {
                WebUtils.Return404(context);
                return;
            }


            IFile topicPhoto = MicroBlogTopics.GetTopicPhoto(topicID);
            if (topicPhoto != null)
            {
                DateTime lastModified = topicPhoto.LastModified.ToUniversalTime();
                if (enableCaching && IsCacheOK(context, lastModified))
                {
                    WebUtils.Return304(context);
                    return;
                }
                else
                {
                    context.Response.ContentType = "image/jpeg";

                    FileSystemFile fileSystemFile = topicPhoto as FileSystemFile;
                    if (fileSystemFile != null && (!fileSystemFile.FullLocalPath.StartsWith(@"\")))
                    {
                        context.Response.TransmitFile(fileSystemFile.FullLocalPath);
                    }
                    else
                    {
                        context.Response.AddHeader("Content-Length", topicPhoto.ContentLength.ToString("0"));
                        using (Stream stream = topicPhoto.OpenReadStream())
                        {
                            if (stream == null)
                            {
                                WebUtils.Return404(context);
                                return;
                            }
                            int bufferLength = topicPhoto.ContentLength <= DownloadFileHandlerBase.BufferLength ? topicPhoto.ContentLength : DownloadFileHandlerBase.BufferLength;
                            byte[] buffer = new byte[bufferLength];
                            int readedSize;
                            while ((readedSize = stream.Read(buffer, 0, bufferLength)) > 0)
                            {
                                if (!context.Response.IsClientConnected)
                                    break;

                                context.Response.OutputStream.Write(buffer, 0, readedSize);
                            }
                            stream.Close();
                            stream.Dispose();
                            context.Response.OutputStream.Flush();
                            context.Response.Flush();
                        }
                    }
                    if (enableCaching)
                    {
                        context.Response.Cache.SetCacheability(HttpCacheability.Private);
                        context.Response.Cache.SetLastModified(lastModified);
                        context.Response.Cache.SetETag(lastModified.Ticks.ToString());
                        context.Response.Cache.SetAllowResponseInBrowserHistory(true);
                        context.Response.Cache.SetValidUntilExpires(true);
                    }

                    else
                    {
                        context.Response.Cache.SetExpires(DateTime.Now.AddMonths(-1));
                    }
                }
            }

            context.Response.Cache.VaryByParams["topicID"] = true;
            context.Response.Cache.VaryByParams["enableCaching"] = true;
            context.Response.End();
        }
    }
}
