﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Utils;

using SpaceBuilder.Common;
using System.IO;
using System.Web;
using SpaceBuilder.Common.Handlers;

namespace SpaceBuilder.MicroBlog.Handlers
{
    public class MicroBlogTopicUrlHandler : IHttpHandler
    {

        public bool IsReusable
        {
            get { return true; }
        }
        public void ProcessRequest(HttpContext context)
        {

            string topic = context.Request.QueryString["topic"].ToString();
            if (string.IsNullOrEmpty(topic))
            {
                WebUtils.Return404(context);
                return;
            }
            topic = WebUtils.UrlDecode(topic);

            int mode = (int)PostModes.Web;
            if (!string.IsNullOrEmpty(context.Request.QueryString["mode"]))
                int.TryParse(context.Request.QueryString["mode"], out mode);

            string url = string.Empty;
            int topicID = MicroBlogTopics.GetTopicIDByTopic(topic);
            if (topicID > 0)
                url = SiteUrls.Instance().Topic(topicID, null);
            else
                url = SiteUrls.Instance().SearchTopic(topic, (PostModes)mode);

            WebUtils.Redirect301(context, url);
        }

    }
}
