﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using System.Text.RegularExpressions;

using SpaceBuilder.Web;
using SpaceBuilder.Utils;
using System.Web.Routing;

namespace SpaceBuilder.MicroBlog.Modules
{
    public class DisposeActivityForMicroBlog : IMicroBlogModule
    {
        #region IMicroBlogModule 成员

        public void Init(MicroBlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterMicroBlogThreadChange += new MicroBlogThreadEventHandler(em_AfterMicroBlogThreadChange);
            em.AfterMicroBlogCommentChange += new MicroBlogCommentEventHandler(em_AfterMicroBlogCommentChange);
        }

        void em_AfterMicroBlogThreadChange(MicroBlogThread thread, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewMicroBlogThread();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(thread.UserID, false);

                if (user == null)
                    return;

                #region 处理个人动态
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;

                userActivity.Subject = GetBodyWithHyperlink(thread, user);
                //userActivity.Body = thread.Body;

                userActivity.RelativeItemID = thread.ThreadID;
                //userActivity.RelativeItemName = thread.Body;

                Activities.CreateUserActivity(userActivity);
                #endregion


                #region 处理朋友动态
                UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                //判断用户是否允许发送给 朋友动态项目

                if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                {
                    FriendActivity friendActivity = new FriendActivity();
                    friendActivity.ApplicationID = activityItem.ApplicationID;
                    friendActivity.ActivityItemID = activityItem.ItemID;
                    friendActivity.LeadingActorUserID = user.UserID;
                    friendActivity.LeadingActor = user.DisplayName;
                    friendActivity.Subject = userActivity.Subject;
                    //friendActivity.Body = thread.Body;
                    friendActivity.RelativeItemID = thread.ThreadID;
                    //friendActivity.RelativeItemName = thread.Body;

                    List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                    Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                }
                #endregion
            }
        }

        void em_AfterMicroBlogCommentChange(MicroBlogComment comment, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewMicroBlogComment();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(comment.UserID, false);

                if (user == null)
                    return;

                MicroBlogThread thread = MicroBlogThreads.GetThread(comment.ThreadID, false);

                if (thread == null)
                    return;

                UserActivity userActivity = new UserActivity();

                #region 处理个人动态

                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = GetCommentWithHyperlink(thread, comment, user);

                userActivity.RelativeItemID = comment.ThreadID;
                //userActivity.RelativeItemName = comment.Body;
                if (thread.UserID != user.UserID)
                {
                    Activities.CreateUserActivity(userActivity);
                }
                #endregion

                #region 处理朋友动态
                UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                //判断用户是否允许发送给 朋友动态项目

                if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                {
                    FriendActivity friendActivity = new FriendActivity();
                    friendActivity.ApplicationID = activityItem.ApplicationID;
                    friendActivity.ActivityItemID = activityItem.ItemID;
                    friendActivity.LeadingActorUserID = user.UserID;
                    friendActivity.LeadingActor = user.DisplayName;
                    friendActivity.Subject = userActivity.Subject;

                    friendActivity.RelativeItemID = comment.ThreadID;
                    //friendActivity.RelativeItemName = comment.Body;

                    List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                    Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                }
                #endregion
            }
        }

        private string GetBodyWithHyperlink(MicroBlogThread thread, User author)
        {
            StringBuilder sb = new StringBuilder();
            string body = thread.UserDataBody.Replace("</a>", "");
            Regex rg = new Regex("<a [\\w:;\"& =/.]*>", RegexOptions.Multiline | RegexOptions.Singleline);

            Match match = rg.Match(thread.UserDataBody);
            while (match.Success)
            {
                body = body.Replace(match.Value, "");
                match = match.NextMatch();
                if (match.Success)
                    break;
            }

            sb.AppendFormat("{0}:<a href=\"{2}\">{1}</a>", SPBHtmlHelper.Instance().UserDisplayNameLink(author, true), body, SiteUrls.Instance().ShowMicroBlog(thread.UserID, thread.ThreadID));
            return sb.ToString();
        }

        private string GetCommentWithHyperlink(MicroBlogThread thread, MicroBlogComment comment, User author)
        {

            return string.Format("{0}评论{1}的微博：<a href=\"{2}\" target=\"_blank\">{3}</a>", SPBHtmlHelper.Instance().UserDisplayNameLink(author, true), SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID, thread.Author, true), SiteUrls.Instance().ShowMicroBlog(thread.UserID, thread.ThreadID), comment.Body);
        }

        #endregion
    }
}
