﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.MicroBlog.Modules
{
    /// <summary>
    /// 删除用户时处理微博
    /// </summary>
    public class DisposeMicroBlogForDeleteUser : IGlobalModule
    {
        #region IGlobalModule 成员

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement node)
        {
            gem.UserDelete += new UserDeleteEventHandler(gem_UserDelete);
            gem.UserDeleteAndReassignContent += new UserDeleteEventHandler(gem_UserDelete);
        }

        void gem_UserDelete(User user, string reassignUserName)
        {
            try
            {
                if (user.UserType == UserTypes.PersonUser)
                    MicroBlogThreads.DeleteUser(user.UserID);
            }
            catch (Exception e)
            {
                Logger logger = LoggerFactory.GetLogger();
                logger.Error("删除用户微博内容时出现错误", e);
            }
        }

        #endregion
    }
}
