//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.Text;

using System.Web;
using SpaceBuilder.MicroBlog;
using SpaceBuilder.Common;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Web;
using SpaceBuilder.Utils;

namespace SpaceBuilder.MicroBlog.Modules
{
    /// <summary>
    /// ص֪ͨ
    /// </summary>
    public class DisposeNoticeForMicroBlog : IMicroBlogModule
    {

        #region IMicroBlogModule Ա

        public void Init(MicroBlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.AfterMicroBlogCommentChange += new MicroBlogCommentEventHandler(em_AfterMicroBlogCommentChange);
        }

        void em_AfterMicroBlogCommentChange(MicroBlogComment comment, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                MicroBlogThread thread = MicroBlogThreads.GetThread(comment.ThreadID, false);
                User toUser = Users.GetUser(thread.OwnerUserID, false);
                if (toUser == null)
                    return;
                if (comment.UserID == toUser.UserID)
                    return;
                string itemKey = NoticeItemKeys.Instance().NewMicroBlogComment();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                NoticeRecord record = new NoticeRecord();
                record.ApplicationID = ApplicationIDs.Instance().MicroBlog();
                record.UserID = toUser.UserID;
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = comment.UserID;
                record.LeadingActor = comment.Author;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().MicroBlog());
                record.RelativeItemID = thread.ThreadID;
                record.RelativeItemName = thread.ForwardBody;
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewMicroBlogComment", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(comment.UserID, comment.Author, true), GetMicroBlogingNameWithHyperlink(thread));
                record.Body = comment.Body;
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }
        /// <summary>
        /// ȡӵְλƵhtml
        /// </summary>
        private static string GetMicroBlogingNameWithHyperlink(MicroBlogThread thread)
        {
            return string.Format("<a {0} href=\"{1}\" target=\"_blank\">{2}</a>", HyperlinkTargetOfUserActivity, SiteUrls.Instance().UserChannelHome(thread.UserID, ApplicationIDs.Instance().MicroBlog()), HtmlUtils.TrimHtml(thread.ForwardBody, 25));
        }
        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
        #endregion
    }
}
