﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

using SpaceBuilder.Utils;

namespace SpaceBuilder.MicroBlog.Modules
{
    public class DisposePointForMicroBlog : IMicroBlogModule
    {
        #region IMicroBlogModule 成员

        public void Init(MicroBlogEventManager em, System.Xml.Linq.XElement node)
        {
            //em.AfterMicroBlogThreadChange += new MicroBlogThreadEventHandler(em_AfterMicroBlogThreadChange);
            //em.AfterMicroBlogCommentChange += new MicroBlogCommentEventHandler(em_AfterMicroBlogCommentChange);
            em.AfterPointChangeOfMicroBlogComent += new PointChangeOfMicroBlogCommentHandler(em_AfterPointChangeOfMicroBlogComent);
            em.AfterPointChangeOfMicroBlogThread += new PointChangeOfMicroBlogThreadHandler(em_AfterPointChangeOfMicroBlogThread);
        }

        void em_AfterPointChangeOfMicroBlogThread(MicroBlogThread thread, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            if ((e.State == ObjectState.Create || e.State == ObjectState.Delete))
            {
                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;
                User user = Users.GetUser(thread.UserID, false);
                if (user == null)
                    return;
                if (userPointDirection == UserPointDirection.Input)
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateMicroBlogThread());
                    if (e.State == ObjectState.Create)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateMicroBlogThread", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(thread.Body, 14));
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_MicroBlogThreadAuditingSuccess", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(thread.Body, 14));
                }
                else
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteMicroBlogThread());
                    if (e.State == ObjectState.Delete)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteMicroBlogThread", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(thread.Body, 14));
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_MicroBlogThreadAuditingFail", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(thread.Body, 14));
                }

                if (role == null)
                    return;

                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, thread.OwnerUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);
            }
        }

        void em_AfterPointChangeOfMicroBlogComent(MicroBlogComment comment, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            if ((e.State == ObjectState.Create || e.State == ObjectState.Delete))
            {
                UserPointItemRole role = null;
                User user = Users.GetUser(comment.UserID, false);
                if (user == null)
                    return;
                string userPointRecordDescription = string.Empty;
                MicroBlogThread thread = MicroBlogThreads.GetThread(comment.ThreadID, false);
                if (userPointDirection == UserPointDirection.Input)
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateMicroBlogComment());
                    if (e.State == ObjectState.Create)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateMicroBlogComment", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(thread.Body, 14));
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_MicroBlogCommentAuditingSuccess", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(thread.Body, 14));
                }
                else
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteMicroBlogComment());
                    if (e.State == ObjectState.Delete)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteMicroBlogComment", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(comment.Body, 14));
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_MicroBlogCommentAuditingFail", user.Language, e.ApplicationID), HtmlUtils.TrimHtml(comment.Body, 14));
                }
                if (role == null)
                    return;

                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, comment.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                Points.CreateUserPointRecords(records);
            }
        }

        #endregion

    }
}
