﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Text.RegularExpressions;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.MicroBlog.Modules
{
    public class MicroBlogBodyReplace : IMicroBlogModule
    {
        #region IMicroBlogModule 成员

        public void Init(MicroBlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforMicroBlogBodyChange += new MicroBlogBodyEventHandler(em_BeforMicroBlogBodyChange);
        }

        public List<int> em_BeforMicroBlogBodyChange(MicroBlogThread thread, SpaceBuilder.Common.GlobalEventArgs e)
        {

            List<int> userIDs = null;
            if (e.State == ObjectState.Create && thread != null)
            {
                thread.LinkBody = thread.ForwardBody = thread.Body;

                //检索Url
                SeekUrl(thread);

                //检索话题
                SeekTopic(thread);

                //检索提到的用户
                SeekUserName(thread, out userIDs);

                //表情处理
                if (SPBConfig.Instance().EnableEmoticon)
                    thread.LinkBody = EmotionManager.Instance().EmoticonTransforms(thread.LinkBody);

                if (thread.ThreadID <= 0)
                {
                    thread.UserDataBody = thread.LinkBody;
                    if (thread.HasPhoto)
                        thread.UserDataBody = string.Format(thread.LinkBody + SPBHtmlHelper.Instance().Icon(IconTypes.Picture, "图片微博", new RouteValueDictionary { { "class", "tn-icon-inline" } }));
                }

            }

            return userIDs;
        }

        /// <summary>
        /// 检索Url
        /// </summary>
        /// <param name="thread"></param>
        /// <param name="userIDs"></param>
        private void SeekUrl(MicroBlogThread thread)
        {

            List<int> indexes = new List<int>();
            int index = 0;

            if (thread.Body.Contains("http://"))
            {

                while (index > -1)
                {
                    index = thread.Body.IndexOf("http://", index);
                    if (index > -1)
                    {
                        indexes.Add(index);
                        index++;
                    }
                }
            }

            if (indexes.Count <= 0)
                return;

            string newBody = thread.Body, nolinkBody = thread.Body;
            string strUrl = string.Empty, strPreUrl = string.Empty, alias = string.Empty, urlDomain = string.Empty;
            if (!string.IsNullOrEmpty(SPBConfig.Instance().ShortUrlDomain))
                urlDomain = SPBConfig.Instance().ShortUrlDomain.Remove(0, 7);

            int lenth = 0;
            UrlInfo info = null;
            Regex rg = new Regex(@"(?<=(http\:\/\/))[^\u4e00-\u9fa5^(\r\n)^ ^\,^\u3002^\uff1b^\uff0c^\uff1a^\u201c^\u201d^\uff08^\uff09^\u3001^\uff1f^\u300a^\u300b]*", RegexOptions.Multiline | RegexOptions.Singleline);
            for (int i = 0; i < indexes.Count; i++)
            {

                if (i + 1 < indexes.Count)
                    lenth = indexes[i + 1] - indexes[i];
                else
                    lenth = thread.Body.Length - indexes[i];
                strUrl = rg.Match(thread.Body.Substring(indexes[i], lenth)).Value;

                if (!string.IsNullOrEmpty(strUrl) && !strUrl.Equals(strPreUrl, StringComparison.CurrentCultureIgnoreCase))
                    strPreUrl = strUrl;
                else
                    continue;



                if (thread.ThreadID > 0)
                    info = UrlManager.Instance().GetUrlInfo(strUrl);
                else
                {

                    if (strUrl.StartsWith(urlDomain))
                    {
                        string temalias = strUrl.Substring(strUrl.LastIndexOf('/') + 1);
                        if (temalias.Length == 6)
                            info = UrlManager.Instance().GetUrlInfo(temalias);
                        else
                            info = null;
                    }
                    if (info == null)
                    {
                        if (string.IsNullOrEmpty(alias))
                            info = UrlManager.Instance().CreateUrlInfo("http://" + strUrl);
                        else
                            info = UrlManager.Instance().GetUrlInfo(alias);
                    }
                }
                if (info == null)
                    continue;
                if (string.IsNullOrEmpty(thread.ThumbnailUrl))
                    thread.ThumbnailUrl = info.ThumbnailUrl;
                if (string.IsNullOrEmpty(thread.PlayUrl))
                    thread.PlayUrl = info.PlayUrl;

                string mediaIcon = string.Empty;
                if (info.MediaType == MediaTypes.Video)
                    mediaIcon = "<span class=\"tn-icon tn-icon-movie tn-icon-inline\"></span>";
                else if (info.MediaType == MediaTypes.Music)
                    mediaIcon = "<span class=\"tn-icon tn-icon-music tn-icon-inline\"></span>";

                newBody = newBody.Replace("http://" + strUrl, string.Format("<a href=\"{0}\" target=\"_blank\" type=\"{3}\" playUrl=\"{2}\">{4}{1}</a>", info.URL, mediaIcon, info.PlayUrl, info.MediaType.ToString(), "http://" + urlDomain.Remove(urlDomain.Length - 1) + SiteUrls.Instance().RedirectUrl(info.Alias)));
                thread.ForwardBody = thread.ForwardBody.Replace("http://" + strUrl, "http://" + urlDomain.Remove(urlDomain.Length - 1) + SiteUrls.Instance().RedirectUrl(info.Alias));
                if (thread.ThreadID <= 0)
                {
                    switch (info.MediaType)
                    {
                        case MediaTypes.Music:
                            thread.HasMusic = true;
                            break;
                        case MediaTypes.Video:
                            thread.HasVideo = true;
                            break;
                        default:
                            break;
                    }

                    nolinkBody = nolinkBody.Replace("http://" + strUrl, "http://" + info.Alias);
                }
                alias = string.Empty;
            }
            if (thread.ThreadID <= 0)
                thread.Body = nolinkBody;

            thread.LinkBody = newBody;
        }

        /// <summary>
        /// 查找内容中的话题
        /// </summary>
        /// <param name="thread"></param>
        /// <param name="indexes"></param>
        /// <returns></returns>
        private void SeekTopic(MicroBlogThread thread)
        {
            List<int> indexes = new List<int>();
            int index = -1;

            if (!thread.Body.Contains("#"))
                return;

            User currentUser = Globals.GetCurrentUser();
            string newBody = thread.LinkBody;
            string strTopic = string.Empty, strPreTopic = string.Empty;
            Regex rg = new Regex(@"(?<=(?<!\&)(\#)(?!\d\;))[^\#]*(?=(?<!\&)(\#)(?![0-9]+\;))", RegexOptions.Multiline | RegexOptions.Singleline);

            Match m = rg.Match(thread.Body);
            if (!m.Success)
                return;
            int i = 0;
            while (m != null)
            {

                if (i % 2 == 1)
                {
                    m = m.NextMatch();
                    i++;
                    continue;
                }

                if (index == m.Index)
                    break;

                index = m.Index;
                strTopic = m.Value;

                if (!strTopic.Equals(strPreTopic, StringComparison.CurrentCultureIgnoreCase) && !string.IsNullOrEmpty(strTopic))
                    strPreTopic = strTopic;
                else
                    continue;

                if (!string.IsNullOrEmpty(strTopic))
                {

                    string topicUrl = SiteUrls.Instance().TopicUrl(strTopic, (int)thread.PostMode);

                    newBody = newBody.Replace("#" + strTopic + "#", string.Format("<a href=\"{0}\" target=\"_blank\">#{1}#</a>", topicUrl, strTopic.Replace("@", "@.")));
                    if (thread.ThreadID <= 0)
                    {
                        MicroBlogTopic topic = new MicroBlogTopic();
                        topic.Body = strTopic;
                        topic.UserID = currentUser.UserID;
                        MicroBlogTopics.CreateTopic(topic);
                    }
                }
                m = m.NextMatch();
                i++;

            }
            thread.LinkBody = newBody;
        }

        /// <summary>
        /// 检索提到的用户
        /// </summary>
        /// <param name="thread"></param>
        /// <param name="userIDs"></param>
        private void SeekUserName(MicroBlogThread thread, out List<int> userIDs)
        {

            List<int> indexes = new List<int>();
            userIDs = new List<int>();
            int index = 0;

            if (thread.Body.Contains("@"))
            {

                while (index > -1)
                {
                    index = thread.Body.IndexOf("@", index);
                    if (index > -1)
                    {
                        indexes.Add(index);
                        index++;
                    }
                }
            }

            if (indexes.Count <= 0)
                return;

            string newBody = thread.LinkBody;
            string strUserName = string.Empty, strPreUserName = string.Empty;
            int lenth = 0;

            Regex rg = new Regex("(?<=(\\@))[a-zA-Z\u4e00-\u9fa5\\d]*", RegexOptions.Multiline | RegexOptions.Singleline);
            for (int i = 0; i < indexes.Count; i++)
            {

                if (i + 1 < indexes.Count)
                    lenth = indexes[i + 1] - indexes[i];
                else
                    lenth = thread.Body.Length - indexes[i];

                if (string.IsNullOrEmpty(thread.Body))
                    strUserName = rg.Match(thread.Body.Substring(indexes[i], lenth)).Value;
                else
                    strUserName = rg.Match(thread.Body.Substring(indexes[i], lenth)).Value;

                if (!strUserName.Equals(strPreUserName, StringComparison.CurrentCultureIgnoreCase) && !string.IsNullOrEmpty(strUserName))
                    strPreUserName = strUserName;
                else
                    continue;

                string userUrl = string.Empty;

                User user = Users.GetUser(strUserName, false);
                if (user != null)
                {
                    userUrl = string.Format("<a href=\"{0}\" title={1} target=\"_blank\" >{2}</a>", SiteUrls.Instance().MyMicroBlogs(user.UserID), user.DisplayName, "@" + user.DisplayName);
                }
                else
                {
                    userUrl = string.Format("<a href=\"{0}\" title={1} target=\"_blank\">{2}</a>", SPBUrlHelper.Action("SearchUsers", "MicroBlog", new RouteValueDictionary { { "Keyword", WebUtils.UrlEncode(strUserName) } }), strUserName, "@" + strUserName);
                }

                newBody = newBody.Replace("@" + strUserName, userUrl);
                if (thread.ThreadID <= 0 && user != null)
                    userIDs.Add(user.UserID);


            }
            thread.LinkBody = newBody.Replace("@.", "@");
        }

        #endregion
    }
}
