﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Utils;
using System.Web.Routing;
using System.Text.RegularExpressions;
using SpaceBuilder.Web;


namespace SpaceBuilder.MicroBlog.Modules
{
    public class MicroBlogCommentFormatting : IMicroBlogModule
    {
        #region IMicroBlogModule 成员

        public void Init(MicroBlogEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforMicroBlogCommentChange += new MicroBlogCommentEventHandler(em_BeforMicroBlogCommentChange);
        }

        void em_BeforMicroBlogCommentChange(MicroBlogComment comment, SpaceBuilder.Common.GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                //处理标签
                comment.Body = WebUtils.HtmlEncode(comment.Body);

                //敏感词过滤
                if (SiteSettingsManager.GetSiteSettings().EnableCensorship)
                {
                    comment.Body = Censors.CensorPost(comment.Body);
                }

                //表情处理
                if (SPBConfig.Instance().EnableEmoticon)
                    comment.Body = EmotionManager.Instance().EmoticonTransforms(comment.Body);

                comment.Body = SeekUserName(comment.Body);
            }
        }

        /// <summary>
        /// 提换用户名
        /// </summary>
        /// <param name="comment"></param>
        private string SeekUserName(string body)
        {

            List<int> indexes = new List<int>();
            int index = 0;

            if (body.Contains("@"))
            {

                while (index > -1)
                {
                    index = body.IndexOf("@", index);
                    if (index > -1)
                    {
                        indexes.Add(index);
                        index++;
                    }
                }
            }

            if (indexes.Count <= 0)
                return body;

            string newBody = body;
            string strUserName = string.Empty, strPreUserName = string.Empty;
            int lenth = 0;

            Regex rg = new Regex("(?<=(\\@))[a-zA-Z\u4e00-\u9fa5\\d]*", RegexOptions.Multiline | RegexOptions.Singleline);
            for (int i = 0; i < indexes.Count; i++)
            {

                if (i + 1 < indexes.Count)
                    lenth = indexes[i + 1] - indexes[i];
                else
                    lenth = body.Length - indexes[i];

                strUserName = rg.Match(body.Substring(indexes[i], lenth)).Value;

                if (!strUserName.Equals(strPreUserName, StringComparison.CurrentCultureIgnoreCase) && !string.IsNullOrEmpty(strUserName))
                    strPreUserName = strUserName;
                else
                    continue;

                string userUrl = string.Empty;

                User user = Users.GetUser(strUserName, false);
                if (user != null)
                {
                    userUrl = string.Format("<a href=\"{0}\" title={1}>{2}</a>", SiteUrls.Instance().MyMicroBlogs(user.UserID), user.DisplayName, "@" + user.DisplayName);
                    newBody = newBody.Replace("@" + strUserName, userUrl);
                }

            }
            return newBody;
        }


        #endregion
    }
}
